/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.reservation;

import be.recipe.api.Prescription;
import be.recipe.api.executor.Executor;
import be.recipe.api.reservation.ContactPreference;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Comparator;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.threeten.bp.LocalDateTime;

public interface Reservation {
    public static final String status_should_be_x = "reservation.status.should.be.%s";
    public static final String status_should_not_be_x = "reservation.status.should.not.be.%s";
    public static final String not_found = "reservation.not.found";
    public static final String supports_reservations = "supports.reservations";
    public static final String invalid_executor_id_format = "error.validation.vision.invalid.message";
    public static final String prescription_status_invalid = "prescription.status.invalid.for.reservation";
    public static final Reservation NULL = new Simple();

    public Prescription.Encrypted prescription();

    public Executor.ID executor();

    public LocalDateTime creationDateTime();

    public boolean newInfoForPatient();

    public boolean newInfoForExecutor();

    public Status status();

    public String feedbackToPatient();

    public LocalDateTime updateDateTime();

    public String email();

    public String phoneNumber();

    public ContactPreference contactPreference();

    public static class Simple
    implements Reservation {
        private LocalDateTime creationDateTime;
        private LocalDateTime updateDateTime;
        private String feedbackToPatient;
        private String email;
        private String phoneNumber;
        private ContactPreference contactPreference;
        private Prescription.Encrypted prescription;
        private boolean newInfoForPatient;
        private boolean newInfoForExecutor;
        private Executor.ID executor;
        private Status status;

        public static Simple reservation(Prescription.Encrypted prescription) {
            return new Simple().prescription(prescription);
        }

        public static Simple reservation(Executor.ID executorId) {
            return new Simple().executor(executorId);
        }

        @Override
        public Prescription.Encrypted prescription() {
            return this.prescription;
        }

        @Override
        public Executor.ID executor() {
            return this.executor;
        }

        @Override
        public LocalDateTime creationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public boolean newInfoForPatient() {
            return this.newInfoForPatient;
        }

        @Override
        public boolean newInfoForExecutor() {
            return this.newInfoForExecutor;
        }

        @Override
        public Status status() {
            return this.status;
        }

        @Override
        public String feedbackToPatient() {
            return this.feedbackToPatient;
        }

        @Override
        public LocalDateTime updateDateTime() {
            return this.updateDateTime;
        }

        @Override
        public String email() {
            return this.email;
        }

        @Override
        public String phoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public ContactPreference contactPreference() {
            return this.contactPreference;
        }

        public Simple creationDateTime(LocalDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public Simple executor(Executor.ID executorId) {
            this.executor = executorId;
            return this;
        }

        public Simple prescription(Prescription.Encrypted prescription) {
            this.prescription = prescription;
            return this;
        }

        public Simple status(Status status) {
            this.status = status;
            return this;
        }

        public Simple feedbackToPatient(String feedbackToPatient) {
            this.feedbackToPatient = feedbackToPatient;
            return this;
        }

        public Simple newInfoForPatient(boolean newInfoForPatient) {
            this.newInfoForPatient = newInfoForPatient;
            return this;
        }

        public Simple newInfoForExecutor(boolean newInfoForExecutor) {
            this.newInfoForExecutor = newInfoForExecutor;
            return this;
        }

        public Simple email(String email) {
            this.email = email;
            return this;
        }

        public Simple phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Simple contactPreference(ContactPreference contactPreference) {
            this.contactPreference = contactPreference;
            return this;
        }
    }

    public static enum Attribute {
        modificationDate;

    }

    public static enum Status {
        REQUESTED_WITHOUT_COMMITMENT("requested without commitment", 0),
        REQUESTED("requested", 2),
        ACCEPTED("accepted", 2),
        REJECTED("rejected", 1),
        CANCELLATION_REQUESTED("cancellation requested", 2),
        CANCELLED("cancelled", 0),
        FULFILLED("fulfilled", 0);

        private String humanReadable;
        private int rank;

        private Status(String humanReadable, int rank) {
            this.humanReadable = humanReadable;
            this.rank = rank;
        }

        public static java.util.Comparator<Status> comparator() {
            return new Comparator();
        }

        public String humanReadable() {
            return this.humanReadable;
        }

        private static class Comparator
        implements java.util.Comparator<Status> {
            private Comparator() {
            }

            @Override
            public int compare(Status x, Status y) {
                return Integer.compare(x.rank, y.rank);
            }
        }

        @Inherited
        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        @Constraint(validatedBy={Validator.class})
        public static @interface ShouldBeOneOf {
            public String message() default "reservation.status.should.not.be.%s";

            public Status[] status();

            public Class<?>[] groups() default {};

            public Class<? extends Payload>[] payload() default {};

            public static class Validator
            implements ConstraintValidator<ShouldBeOneOf, Status> {
                private Status[] expected;

                public void initialize(ShouldBeOneOf constraintAnnotation) {
                    this.expected = constraintAnnotation.status();
                }

                public boolean isValid(Status status, ConstraintValidatorContext context) {
                    return status == null || Arrays.asList(this.expected).contains((Object)status);
                }
            }
        }
    }
}

