/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescriber;

import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.Registered;
import be.recipe.api.constraints.SSIN;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriptionWrapper;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.projections.SearchResult;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.SortedBy;
import be.recipe.api.series.Window;
import be.recipe.api.time.LocalDateRange;
import java.util.List;
import java8.util.function.Function;
import java8.util.function.Functions;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.RefStreams;
import java8.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.threeten.bp.LocalDate;

public class ListPrescriptions {
    @SSIN
    @Valid
    @NotNull(message="required")
    public Patient.ID patient;
    public Prescription.Status[] status;
    public LocalDateRange between;
    public LocalDateRange expiringBetween;
    public Prescriber.ID prescriberId;
    @Valid
    public Window window = Window.offset(0);
    public SortedBy<Prescription.Attribute>[] sortedBy;

    public ListPrescriptions sortedBy(SortedBy<Prescription.Attribute> sortedBy) {
        this.sortedBy = ((List)RefStreams.of((Object[])new Stream[]{RefStreams.of(sortedBy), this.sortedBy == null ? RefStreams.empty() : RefStreams.of((Object[])this.sortedBy)}).flatMap(Functions.identity()).collect(Collectors.toList())).toArray(new SortedBy[0]);
        return this;
    }

    public static interface PartialResult<T extends Response>
    extends be.recipe.api.series.PartialResult<T> {
        public boolean hasHidden();

        public static class Simple<T extends Response>
        extends PartialResult.Wrapper<T>
        implements PartialResult<T> {
            private boolean hidden;

            public static <T extends Response> Simple<T> wrap(be.recipe.api.series.PartialResult<T> target) {
                return new Simple<T>(target);
            }

            public static <T extends Response> Simple<T> wrap(PartialResult<T> target, Supplier<be.recipe.api.series.PartialResult<T>> factory) {
                return new Simple<T>(target, factory);
            }

            public Simple(be.recipe.api.series.PartialResult<T> target) {
                super(target);
            }

            public Simple(PartialResult<T> target, Supplier<be.recipe.api.series.PartialResult<T>> factory) {
                super((be.recipe.api.series.PartialResult)factory.get());
                this.hasHidden(target.hasHidden());
            }

            @Override
            public boolean hasHidden() {
                return this.hidden;
            }

            public Simple<T> hasHidden(boolean it) {
                this.hidden = it;
                return this;
            }
        }
    }

    public static interface Response
    extends Registered {
        public Prescription.Status status();

        public SearchResult.Prescriber prescriber();

        public LocalDate creationDate();

        public LocalDate expirationDate();

        public VisionOtherPrescribers visionOtherPrescribers();

        public static class Wrapper
        implements Response {
            protected final Response target;

            public Wrapper(Response target) {
                this.target = target;
            }

            @Override
            public Prescription.RID rid() {
                return this.target.rid();
            }

            @Override
            public Prescription.Status status() {
                return this.target.status();
            }

            @Override
            public SearchResult.Prescriber prescriber() {
                return this.target.prescriber();
            }

            @Override
            public LocalDate creationDate() {
                return this.target.creationDate();
            }

            @Override
            public LocalDate expirationDate() {
                return this.target.expirationDate();
            }

            @Override
            public VisionOtherPrescribers visionOtherPrescribers() {
                return this.target.visionOtherPrescribers();
            }
        }

        public static abstract class AbstractSimpleResponse
        implements Response {
            public Prescription.RID rid;
            public SearchResult.Prescriber prescriber;
            public Prescription.Status status;
            public LocalDate creationDate;
            public LocalDate expirationDate;
            public VisionOtherPrescribers visionOtherPrescribers;

            public AbstractSimpleResponse() {
            }

            public AbstractSimpleResponse(Response from) {
                this.visionOtherPrescribers = from.visionOtherPrescribers();
                this.expirationDate = from.expirationDate();
                this.creationDate = from.creationDate();
                this.prescriber = from.prescriber();
                this.status = from.status();
                this.rid = from.rid();
            }

            @Override
            public Prescription.RID rid() {
                return this.rid;
            }

            @Override
            public Prescription.Status status() {
                return this.status;
            }

            @Override
            public SearchResult.Prescriber prescriber() {
                return this.prescriber;
            }

            @Override
            public LocalDate creationDate() {
                return this.creationDate;
            }

            @Override
            public LocalDate expirationDate() {
                return this.expirationDate;
            }

            @Override
            public VisionOtherPrescribers visionOtherPrescribers() {
                return this.visionOtherPrescribers;
            }
        }

        public static abstract class AbstractWrapper<T extends Response>
        implements Response {
            final T target;

            public AbstractWrapper(T target) {
                this.target = target;
            }

            @Override
            public Prescription.RID rid() {
                return this.target.rid();
            }

            @Override
            public LocalDate creationDate() {
                return this.target.creationDate();
            }

            @Override
            public LocalDate expirationDate() {
                return this.target.expirationDate();
            }

            @Override
            public Prescription.Status status() {
                return this.target.status();
            }

            @Override
            public SearchResult.Prescriber prescriber() {
                return this.target.prescriber();
            }

            @Override
            public VisionOtherPrescribers visionOtherPrescribers() {
                return this.target.visionOtherPrescribers();
            }
        }

        public static interface Encrypted
        extends Response {
            public byte[] encryptedPrescriptionContent();

            public String encryptionKey();

            public static class Wrapper
            extends AbstractWrapper<Encrypted>
            implements Encrypted {
                public Wrapper(Encrypted target) {
                    super(target);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return ((Encrypted)this.target).encryptedPrescriptionContent();
                }

                @Override
                public String encryptionKey() {
                    return ((Encrypted)this.target).encryptionKey();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements Encrypted {
                public byte[] encryptedPrescriptionContent;
                public String encryptionKey;

                public static Simple response(Prescription.RID rid) {
                    Simple it = new Simple();
                    it.rid = rid;
                    return it;
                }

                public static Encrypted wrapper(Prescription.Encrypted prescription) {
                    return new PrescriptionWrapper.Encrypted(prescription);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return this.encryptedPrescriptionContent;
                }

                @Override
                public String encryptionKey() {
                    return this.encryptionKey;
                }

                public Simple prescriptionContent(PrescriptionContent.Encrypted encrypted) {
                    this.encryptionKey = encrypted.key().toString();
                    this.encryptedPrescriptionContent = encrypted.bytes();
                    return this;
                }

                public PlainText.Simple prescriptionContent(String prescriptionContent) {
                    return new PlainText.Simple(this).prescriptionContent(prescriptionContent);
                }
            }
        }

        public static interface PlainText
        extends Response {
            public String prescriptionContent();

            public static class Wrapper
            extends AbstractWrapper<PlainText>
            implements PlainText {
                public Wrapper(PlainText target) {
                    super(target);
                }

                @Override
                public String prescriptionContent() {
                    return ((PlainText)this.target).prescriptionContent();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements PlainText {
                public String prescriptionContent;

                public static Simple response(Prescription.RID rid) {
                    Simple it = new Simple();
                    it.rid = rid;
                    return it;
                }

                private Simple() {
                }

                public Simple(Encrypted from) {
                    super(from);
                }

                @Override
                public String prescriptionContent() {
                    return this.prescriptionContent;
                }

                public Simple prescriptionContent(String prescriptionContent) {
                    this.prescriptionContent = prescriptionContent;
                    return this;
                }

                public Simple content(String prescriptionContent) {
                    this.prescriptionContent = prescriptionContent;
                    return this;
                }

                public static Function<PlainText, String> toPrescriptionContent() {
                    return new Function<PlainText, String>(){

                        public String apply(PlainText it) {
                            return it.prescriptionContent();
                        }
                    };
                }
            }
        }
    }

    public static interface Command<Request extends ListPrescriptions, Response extends Response> {
        public PartialResult<Response> list(Request var1);
    }
}

