/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.patient.ListPrescriptions;
import be.recipe.api.patient.Patient;
import be.recipe.api.patient.ReservationWrapper;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.reservation.Reservation;
import java8.util.Optional;
import java8.util.function.Function;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

class PrescriptionWrapper
implements ListPrescriptions.Response.Encrypted {
    private final Prescription.Encrypted target;

    public PrescriptionWrapper(Prescription.Encrypted target) {
        this.target = target;
    }

    @Override
    public Prescription.RID rid() {
        return this.target.rid();
    }

    @Override
    public Patient.ID patient() {
        return this.target.patient().id();
    }

    @Override
    public Prescriber.ID prescriber() {
        return this.target.prescriber().id();
    }

    @Override
    public Prescription.Type type() {
        return this.target.type();
    }

    @Override
    public LocalDate expirationDate() {
        return this.target.expirationDate();
    }

    @Override
    public byte[] encryptedPrescriptionContent() {
        return this.target.encryptedContent();
    }

    @Override
    public String encryptionKey() {
        return this.target.encryptionKey();
    }

    @Override
    public boolean feedbackAllowed() {
        return this.target.feedbackAllowed();
    }

    @Override
    public ExecutorViewer visibleToExecutors() {
        return this.target.visibleToExecutors();
    }

    @Override
    public VisionOtherPrescribers visionOtherPrescribers() {
        return this.target.visionOtherPrescribers();
    }

    @Override
    public Prescription.Status status() {
        return this.target.status();
    }

    @Override
    public LocalDateTime creationDate() {
        return this.target.creationDate();
    }

    @Override
    public Optional<ListPrescriptions.Response.Reservation> reservation() {
        return this.target.reservation().map((Function)new Function<Reservation, ListPrescriptions.Response.Reservation>(){

            public ListPrescriptions.Response.Reservation apply(Reservation reservation) {
                return new ReservationWrapper(reservation);
            }
        });
    }
}

