/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.executor;

import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.Registered;
import be.recipe.api.constraints.SSIN;
import be.recipe.api.executor.AbstractSimpleResponse;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.executor.PrescriptionWrapper;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.series.Page;
import be.recipe.api.series.PartialResult;
import java8.util.function.Function;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public class ListPrescriptions {
    @SSIN
    @NotNull(message="required")
    public Patient.ID patient;
    @SSIN
    public Patient.ID mandateHolder;
    @Valid
    @NotNull(message="required")
    public Page page = Page.first();

    public static ListPrescriptions list(Patient.ID patient) {
        return new ListPrescriptions(patient);
    }

    public ListPrescriptions() {
    }

    @Deprecated
    public ListPrescriptions(Patient.ID patient) {
        this.patient = patient;
    }

    public ListPrescriptions(Patient.ID patient, Page page) {
        this(patient, null, page);
    }

    public ListPrescriptions(Patient.ID patient, Patient.ID mandateHolder, Page page) {
        this.patient = patient;
        this.mandateHolder = mandateHolder;
        this.page = page;
    }

    public ListPrescriptions mandateHolder(Patient.ID mandateHolder) {
        this.mandateHolder = mandateHolder;
        return this;
    }

    public static interface Response
    extends Registered {
        public Prescription.Type type();

        public Patient.ID patient();

        public Prescriber.ID prescriber();

        public LocalDateTime creationDate();

        public LocalDate expirationDate();

        public ExecutorViewer visibleTo();

        public Prescription.Status status();

        public boolean feedbackAllowed();

        public static abstract class AbstractWrapper<T extends Response>
        implements Response {
            final T target;

            public AbstractWrapper(T target) {
                this.target = target;
            }

            @Override
            public Prescription.RID rid() {
                return this.target.rid();
            }

            @Override
            public Prescription.Type type() {
                return this.target.type();
            }

            @Override
            public Patient.ID patient() {
                return this.target.patient();
            }

            @Override
            public Prescriber.ID prescriber() {
                return this.target.prescriber();
            }

            @Override
            public LocalDateTime creationDate() {
                return this.target.creationDate();
            }

            @Override
            public LocalDate expirationDate() {
                return this.target.expirationDate();
            }

            @Override
            public ExecutorViewer visibleTo() {
                return this.target.visibleTo();
            }

            @Override
            public Prescription.Status status() {
                return this.target.status();
            }

            @Override
            public boolean feedbackAllowed() {
                return this.target.feedbackAllowed();
            }
        }

        public static interface Encrypted
        extends Response {
            public byte[] encryptedPrescriptionContent();

            public String encryptionKey();

            public static class Wrapper
            extends AbstractWrapper<Encrypted>
            implements Encrypted {
                public Wrapper(Encrypted target) {
                    super(target);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return ((Encrypted)this.target).encryptedPrescriptionContent();
                }

                @Override
                public String encryptionKey() {
                    return ((Encrypted)this.target).encryptionKey();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements Encrypted {
                public byte[] encryptedPrescriptionContent;
                public String encryptionKey;

                public static Simple response(Prescription.RID rid) {
                    Simple it = new Simple();
                    it.rid = rid;
                    return it;
                }

                public static Encrypted response(Prescription.Encrypted target) {
                    return new PrescriptionWrapper(target);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return this.encryptedPrescriptionContent;
                }

                @Override
                public String encryptionKey() {
                    return this.encryptionKey;
                }

                public Simple prescriptionContent(PrescriptionContent.Encrypted encrypted) {
                    this.encryptionKey = encrypted.key().toString();
                    this.encryptedPrescriptionContent = encrypted.bytes();
                    return this;
                }

                public PlainText.Simple prescriptionContent(String prescriptionContent) {
                    return new PlainText.Simple(this).prescriptionContent(prescriptionContent);
                }
            }
        }

        public static interface PlainText
        extends Response {
            public String prescriptionContent();

            public static class Wrapper
            extends AbstractWrapper<PlainText>
            implements PlainText {
                public Wrapper(PlainText target) {
                    super(target);
                }

                @Override
                public String prescriptionContent() {
                    return ((PlainText)this.target).prescriptionContent();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements PlainText {
                public String prescriptionContent;

                public Simple(Encrypted from) {
                    super(from);
                }

                @Override
                public String prescriptionContent() {
                    return this.prescriptionContent;
                }

                public Simple prescriptionContent(String prescriptionContent) {
                    this.prescriptionContent = prescriptionContent;
                    return this;
                }

                public static Function<PlainText, String> toContent() {
                    return new Function<PlainText, String>(){

                        public String apply(PlainText it) {
                            return it.prescriptionContent();
                        }
                    };
                }
            }
        }
    }

    public static interface Command<Request extends ListPrescriptions, Response extends Response> {
        public PartialResult<Response> list(Request var1);
    }
}

