/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.executor;

import be.recipe.api.Actor;
import be.recipe.api.Prescription;
import be.recipe.api.crypto.Message;
import be.recipe.api.text.ExtendableString;
import java8.util.function.Function;

public interface Executor {
    public ID id();

    public Type type();

    public static class Simple
    implements Executor {
        private Type type;
        private ID id;

        public Simple() {
        }

        public Simple(ID id) {
            this(id, null);
        }

        public Simple(ID id, Type type) {
            this.id = id;
            this.type = type;
        }

        public void setId(ID id) {
            this.id = id;
        }

        @Override
        public ID id() {
            return this.id;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }

    public static class All
    implements Message.Cipher.Key.Owner<Prescription.OnContent> {
        public static All all() {
            return new All();
        }

        @Override
        public void process(Prescription.OnContent processor) {
            processor.process(this);
        }

        public String toString() {
            return this.getClass().getName();
        }

        public boolean equals(Object it) {
            return it instanceof ID;
        }
    }

    public static class Type
    extends ExtendableString {
        private Type(String value) {
            super(value);
        }

        public static Type executorType(String it) {
            return Type.construct(it, new Function<String, Type>(){

                public Type apply(String it) {
                    return new Type(it);
                }
            });
        }
    }

    public static class ID
    extends Actor.ID
    implements Message.Cipher.Key.Owner<Prescription.OnContent> {
        protected ID(String value) {
            super(value);
        }

        @Override
        public void process(Prescription.OnContent processor) {
            processor.process(this);
        }

        public static ID executorId(String it) {
            return ID.construct(it, new Function<String, ID>(){

                public ID apply(String it) {
                    return new ID(it);
                }
            });
        }
    }
}

