/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.constraints;

import be.recipe.api.text.LocalisedMessage;
import java.util.ArrayList;
import java.util.List;
import java8.util.function.Function;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public interface Violation {
    public String name();

    public String propertyPath();

    public String usecase();

    public <T> T value();

    public Stream<LocalisedMessage> translations();

    public static class Wrapper
    implements Violation {
        private final Violation target;

        public Wrapper(Violation target) {
            this.target = target;
        }

        @Override
        public String name() {
            return this.target.name();
        }

        @Override
        public String propertyPath() {
            return this.target.propertyPath();
        }

        @Override
        public String usecase() {
            return this.target.usecase();
        }

        @Override
        public <T> T value() {
            return this.target.value();
        }

        @Override
        public Stream<LocalisedMessage> translations() {
            return this.target.translations();
        }
    }

    public static interface ValueFactory {
        public Object violationValue(String var1);
    }

    public static interface PropertyPathFactory {
        public String propertyPath(String var1);
    }

    public static class Simple
    implements Violation {
        private final List<LocalisedMessage> translations = new ArrayList<LocalisedMessage>();
        private String name;
        private String propertyPath;
        private String usecase;
        private Object value;

        public static Builder violation(String name) {
            return new Builder().name(name);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String propertyPath() {
            return this.propertyPath;
        }

        @Override
        public String usecase() {
            return this.usecase;
        }

        @Override
        public <T> T value() {
            return (T)this.value;
        }

        @Override
        public Stream<LocalisedMessage> translations() {
            return StreamSupport.stream(this.translations);
        }

        public static Function<Violation, String> toViolation() {
            return new Function<Violation, String>(){

                public String apply(Violation violation) {
                    return violation.name();
                }
            };
        }

        public String toString() {
            return "Violation{propertyPath='" + this.propertyPath + '\'' + "name='" + this.name + '\'' + '}';
        }

        public static class Builder {
            private final Simple violation = new Simple();

            public Builder name(String name) {
                this.violation.name = name;
                return this;
            }

            public Violation build() {
                return this.violation;
            }

            public static Function<Builder, Violation> toViolation() {
                return new Function<Builder, Violation>(){

                    public Violation apply(Builder builder) {
                        return builder.build();
                    }
                };
            }

            public Builder on(String propertyPath) {
                this.violation.propertyPath = propertyPath;
                return this;
            }

            public Builder of(String usecase) {
                this.violation.usecase = usecase;
                return this;
            }

            public Builder value(Object value) {
                this.violation.value = value;
                return this;
            }

            public Builder translation(LocalisedMessage translation) {
                this.violation.translations.add(translation);
                return this;
            }
        }
    }
}

