/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.Prescription;
import be.recipe.api.crypto.Cipher;
import be.recipe.api.crypto.Message;
import be.recipe.api.patient.Patient;
import java.util.Objects;

public class PrescriptionContent<M extends Message> {
    protected final Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry;
    protected final M target;

    public PrescriptionContent(M target, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry) {
        this.keyRegistry = keyRegistry;
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrescriptionContent)) {
            return false;
        }
        PrescriptionContent prescriptionContent = (PrescriptionContent)o;
        return ((Message)this.target).equals(prescriptionContent.target);
    }

    public int hashCode() {
        return Objects.hash(this.target);
    }

    public byte[] bytes() {
        return ((Message)this.target).bytes();
    }

    public static class Factory {
        private final Message.Factory messageFactory;
        private final Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry;

        public Factory(Message.Factory messageFactory, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry) {
            this.messageFactory = messageFactory;
            this.keyRegistry = keyRegistry;
        }

        public PlainText create(byte[] bytes) {
            return new PlainText(this.messageFactory.plain(bytes), this.keyRegistry);
        }

        public Encrypted create(byte[] bytes, Message.Cipher.Key.ID key) {
            return new Encrypted(this.messageFactory.encrypted(bytes), this.keyRegistry, key);
        }

        public Encrypted.Timestamped timestamped(byte[] bytes, Message.Cipher.Key.ID key) {
            return new Encrypted.Timestamped(this.messageFactory.timestamped(bytes), this.keyRegistry, key);
        }
    }

    public static class Encrypted
    extends PrescriptionContent<Message.Encrypted> {
        private final Message.Cipher.Key.ID key;

        public Encrypted(Message.Encrypted target, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher.Key.ID key) {
            super(target, keyRegistry);
            this.key = key;
        }

        public PlainText decrypt() {
            try {
                return new PlainText(((Message.Encrypted)this.target).decrypt(this.keyRegistry.get(this.key)), (Message.Cipher.Key.DB<Prescription.OnContent>)this.keyRegistry);
            }
            catch (Message.Cipher.Key.NotFound e) {
                throw new Cipher.Undecipherable(e);
            }
        }

        public Message.Cipher.Key.ID key() {
            return this.key;
        }

        public static class Timestamped
        extends Encrypted {
            public Timestamped(Message.Encrypted.Timestamped target, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry, Message.Cipher.Key.ID key) {
                super(target, keyRegistry, key);
            }
        }
    }

    public static class PlainText
    extends PrescriptionContent<Message.PlainText> {
        public PlainText(Message.PlainText target, Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry) {
            super(target, keyRegistry);
        }

        public Encrypted encrypt(Patient.ID patient, Prescription.Type prescription) {
            Message.Cipher.Key key = this.keyRegistry.create(patient.toString());
            return new Encrypted(((Message.PlainText)this.target).encipher(key), this.keyRegistry, key.id());
        }
    }
}

