/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescription;

import be.recipe.api.PrefetchingPrescriptionService;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionService;
import be.recipe.api.crypto.Cipher;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.series.PartialResult;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java8.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PrefetchingPrescriptionServiceTest {
    private PrescriptionService.Ciphering.Simplified target = (PrescriptionService.Ciphering.Simplified)Mockito.mock(PrescriptionService.Ciphering.Simplified.class);
    private PrefetchingPrescriptionService service = new PrefetchingPrescriptionService(this.target);
    private CountDownLatch latch = new CountDownLatch(1);

    @Test
    public void listAsPrescriper_returnsResponseFromTarget() {
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText.Simple[]{ListPrescriptions.Response.PlainText.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)"-")).content("t")}).hasMore(true)).hasHidden(true));
        ListPrescriptions.PartialResult response = this.service.list(new ListPrescriptions());
        Assertions.assertEquals(Arrays.asList("t"), (Object)response.map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).stream().collect(Collectors.toList()));
        Assertions.assertTrue((boolean)response.hasMore());
        Assertions.assertTrue((boolean)response.hasHidden());
    }

    @Test
    public void listAsPrescriber_prefetchesTreatment() {
        ListPrescriptions.Response.PlainText item = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{item})));
        this.service.list(new ListPrescriptions()).stream().collect(Collectors.toList());
        ((ListPrescriptions.Response.PlainText)Mockito.verify((Object)item)).prescriptionContent();
    }

    @Test
    public void listAsPrescriber_prefetchesTreatment_throwsUndecipherableExceptions() {
        ListPrescriptions.Response.PlainText x = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        ListPrescriptions.Response.PlainText y = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        ListPrescriptions.Response.PlainText z = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{x, y, z})));
        Mockito.when((Object)x.prescriptionContent()).thenReturn((Object)"a");
        Mockito.when((Object)y.prescriptionContent()).thenThrow(Cipher.Undecipherable.class);
        Mockito.when((Object)z.prescriptionContent()).thenReturn((Object)"c");
        final ListPrescriptions.PartialResult response = this.service.list(new ListPrescriptions());
        Assertions.assertEquals((Object)"a", (Object)response.stream().findFirst().map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).get());
        Assertions.assertEquals((Object)"c", (Object)response.stream().skip(2L).findFirst().map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).get());
        Assertions.assertThrows(Cipher.Undecipherable.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                response.stream().skip(1L).findFirst().map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).get();
            }
        });
    }

    @Test
    public void listAsPrescriber_cachesTreatment() {
        ListPrescriptions.Response.PlainText item = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{item})));
        Mockito.when((Object)item.prescriptionContent()).thenReturn((Object)"x", (Object[])new String[]{"-"});
        Assertions.assertEquals(Arrays.asList("x"), (Object)this.service.list(new ListPrescriptions()).map(ListPrescriptions.Response.PlainText.Simple.toPrescriptionContent()).stream().collect(Collectors.toList()));
    }

    @Test
    public void listAsPrescriber_prefetchesTreatmentInParallel() {
        ListPrescriptions.Response.PlainText slow = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        ListPrescriptions.Response.PlainText fast = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{slow, fast})));
        Mockito.when((Object)slow.prescriptionContent()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                PrefetchingPrescriptionServiceTest.this.latch.await();
                return "-";
            }
        });
        Mockito.when((Object)fast.prescriptionContent()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                try {
                    String string = "-";
                    return string;
                }
                finally {
                    PrefetchingPrescriptionServiceTest.this.latch.countDown();
                }
            }
        });
        this.service.list(new ListPrescriptions()).stream().collect(Collectors.toList());
    }

    @Test
    public void listAsPrescriber_streamMultipleTimes() {
        Mockito.when((Object)this.target.list((ListPrescriptions)ArgumentMatchers.any(ListPrescriptions.class))).thenReturn((Object)ListPrescriptions.PartialResult.Simple.wrap((PartialResult)PartialResult.Simple.empty()));
        ListPrescriptions.PartialResult result = this.service.list(new ListPrescriptions());
        result.stream().collect(Collectors.toList());
        result.stream().collect(Collectors.toList());
    }

    @Test
    public void listAsExecutor_returnsResponseFromTarget() {
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)ArgumentMatchers.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{ListPrescriptions.Response.Encrypted.Simple.response((Prescription.RID)Prescription.RID.prescriptionID((String)"-")).prescriptionContent("t")}));
        Assertions.assertEquals(Arrays.asList("t"), (Object)this.service.list(new be.recipe.api.executor.ListPrescriptions()).map(ListPrescriptions.Response.PlainText.Simple.toContent()).stream().collect(Collectors.toList()));
    }

    @Test
    public void listAsExecutor_prefetchesTreatment() {
        ListPrescriptions.Response.PlainText item = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)ArgumentMatchers.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{item}));
        this.service.list(new be.recipe.api.executor.ListPrescriptions()).stream().collect(Collectors.toList());
        ((ListPrescriptions.Response.PlainText)Mockito.verify((Object)item)).prescriptionContent();
    }

    @Test
    public void listAsExecutor_cachesTreatment() {
        ListPrescriptions.Response.PlainText item = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)ArgumentMatchers.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{item}));
        Mockito.when((Object)item.prescriptionContent()).thenReturn((Object)"x", (Object[])new String[]{"-"});
        Assertions.assertEquals(Arrays.asList("x"), (Object)this.service.list(new be.recipe.api.executor.ListPrescriptions()).map(ListPrescriptions.Response.PlainText.Simple.toContent()).stream().collect(Collectors.toList()));
    }

    @Test
    public void listAsExecutor_prefetchesTreatmentInParallel() {
        ListPrescriptions.Response.PlainText slow = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        ListPrescriptions.Response.PlainText fast = (ListPrescriptions.Response.PlainText)Mockito.mock(ListPrescriptions.Response.PlainText.class);
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)ArgumentMatchers.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.of((Object[])new ListPrescriptions.Response.PlainText[]{slow, fast}));
        Mockito.when((Object)slow.prescriptionContent()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                PrefetchingPrescriptionServiceTest.this.latch.await();
                return "-";
            }
        });
        Mockito.when((Object)fast.prescriptionContent()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                try {
                    String string = "-";
                    return string;
                }
                finally {
                    PrefetchingPrescriptionServiceTest.this.latch.countDown();
                }
            }
        });
        this.service.list(new be.recipe.api.executor.ListPrescriptions()).stream().collect(Collectors.toList());
    }

    @Test
    public void listAsExecutor_streamMultipleTimes() {
        Mockito.when((Object)this.target.list((be.recipe.api.executor.ListPrescriptions)ArgumentMatchers.any(be.recipe.api.executor.ListPrescriptions.class))).thenReturn((Object)PartialResult.Simple.empty());
        PartialResult result = this.service.list(new be.recipe.api.executor.ListPrescriptions());
        result.stream().collect(Collectors.toList());
        result.stream().collect(Collectors.toList());
    }
}

