/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.crypto.Cipher;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java8.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public abstract class AbstractPrescriptionContentCipheringTest {
    private PrescriptionContent.Factory factory;

    @BeforeEach
    public void setup() {
        Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry = this.keyRegistry();
        this.factory = new PrescriptionContent.Factory(new Message.Factory(this.cipher(), new Message.Encrypted.Timestamped.Extractor(){

            public byte[] encrypted(byte[] it) {
                return AbstractPrescriptionContentCipheringTest.this.unmarshal(it);
            }
        }), keyRegistry);
    }

    public abstract Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry();

    public abstract Message.Cipher cipher();

    @Test
    public void createPlainTreatment() {
        PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Hello World!", (Object)this.string(plainText.bytes()));
    }

    @Test
    public void encipherTreatment() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        Assertions.assertNotEquals((Object)"Hello World!", (Object)this.string(encrypted.bytes()));
    }

    @Test
    public void decipherAsOriginalPhysician() {
        this.decipherAsOriginalPrescriber(PrescriberType.DOCTOR);
    }

    private void decipherAsOriginalPrescriber(PrescriberType type) {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"prescriber"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(prescriber, new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(AbstractPrescriptionContentCipheringTest.this.factory.create(encrypted.bytes(), encrypted.key()).decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherAsOriginalDentist() {
        this.decipherAsOriginalPrescriber(PrescriberType.DENTIST);
    }

    @Test
    public void decipherAsOriginalMidwife() {
        this.decipherAsOriginalPrescriber(PrescriberType.MIDWIFE);
    }

    @Test
    public void decipherAsOriginalNurse() {
        this.decipherAsOriginalPrescriber(PrescriberType.NURSE);
    }

    @Test
    public void decipherAsOriginalPhysioTherapist() {
        this.decipherAsOriginalPrescriber(PrescriberType.PHYSIOTHERAPIST);
    }

    @Test
    public void decipherAsOriginalHospital() {
        this.decipherAsOriginalPrescriber(PrescriberType.HOSPITAL);
    }

    @Test
    public void decipherAsAnyPhysician() {
        this.decipherAsAnyPrescriberOfType(PrescriberType.DOCTOR);
    }

    private void decipherAsAnyPrescriberOfType(PrescriberType type) {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"x")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"y")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherAsAnotherDentist() {
        this.decipherAsAnyPrescriberOfType(PrescriberType.DENTIST);
    }

    private void decipherAsAnotherPrescriber_rejected(PrescriberType type) {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)type, (Prescriber.ID)Prescriber.ID.prescriberID((String)"?")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertThrows(Cipher.Undecipherable.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        encrypted.decrypt();
                    }
                });
            }
        });
    }

    @Test
    public void decipherAsAnotherMidwife() {
        this.decipherAsAnyPrescriberOfType(PrescriberType.MIDWIFE);
    }

    @Test
    public void decipherAsAnotherNurse_rejected() {
        this.decipherAsAnotherPrescriber_rejected(PrescriberType.NURSE);
    }

    @Test
    public void decipherAsAnotherPhysioTherapist_rejected() {
        this.decipherAsAnotherPrescriber_rejected(PrescriberType.PHYSIOTHERAPIST);
    }

    @Test
    public void decipherAsAnyHospital() {
        this.decipherAsAnyPrescriberOfType(PrescriberType.HOSPITAL);
    }

    @Test
    public void decipherHospitalPrescriptionAsAnyAmbulant() {
        this.decipherPrescriptionBetweenAmbulantAndHospital(PrescriberType.HOSPITAL, PrescriberType.DOCTOR);
    }

    private void decipherPrescriptionBetweenAmbulantAndHospital(PrescriberType from, PrescriberType to) {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)from, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)to, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherAmbulantPrescriptionAsAnyHospital() {
        this.decipherPrescriptionBetweenAmbulantAndHospital(PrescriberType.DOCTOR, PrescriberType.HOSPITAL);
    }

    @Test
    public void decipherAsPhysician_whenPrescribedByDentist() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DENTIST, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"x")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
        this.as(Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"y")), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherAsAnyExecutor() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Executor.ID.executorId((String)"x"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
        this.as(Executor.ID.executorId((String)"y"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
    }

    @Test
    public void decipherAsUnknownPatient_rejected() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Patient.ID.patientID((String)"?"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertThrows(Cipher.Undecipherable.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        encrypted.decrypt();
                    }
                });
            }
        });
    }

    @Test
    public void decipherAsOtherPatient_rejected() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(Patient.ID.patientID((String)"-"), Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(Patient.ID.patientID((String)"o"), new Runnable(){

            @Override
            public void run() {
                Assertions.assertThrows(Cipher.Undecipherable.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        encrypted.decrypt();
                    }
                });
            }
        });
    }

    @Test
    public void decipherAsOriginalPatient() {
        final PrescriptionContent.PlainText plainText = this.factory.create("Hello World!".getBytes(StandardCharsets.UTF_8));
        final Patient.ID patient = this.patient("patient");
        Prescriber.Simple prescriber = Prescriber.Simple.prescriber((PrescriberType)PrescriberType.DOCTOR, (Prescriber.ID)Prescriber.ID.prescriberID((String)"-"));
        final PrescriptionContent.Encrypted encrypted = this.as(prescriber, new Supplier<PrescriptionContent.Encrypted>(){

            public PrescriptionContent.Encrypted get() {
                return plainText.encrypt(patient, Prescription.Type.prescriptionType((String)"P0"));
            }
        });
        this.as(patient, new Runnable(){

            @Override
            public void run() {
                Assertions.assertEquals((Object)"Hello World!", (Object)AbstractPrescriptionContentCipheringTest.this.string(encrypted.decrypt().bytes()));
            }
        });
    }

    protected Patient.ID patient(String patient) {
        return Patient.ID.patientID((String)patient);
    }

    private void as(Prescriber.Simple prescriber, final Runnable task) {
        this.as(prescriber, new Supplier<Object>(){

            public Object get() {
                task.run();
                return null;
            }
        });
    }

    protected abstract <T> T as(Prescriber.Simple var1, Supplier<T> var2);

    private void as(Executor.ID executor, final Runnable task) {
        this.as(executor, new Supplier<Object>(){

            public Object get() {
                task.run();
                return null;
            }
        });
    }

    protected abstract <T> T as(Executor.ID var1, Supplier<T> var2);

    private void as(Patient.ID patient, final Runnable task) {
        this.as(patient, new Supplier<Object>(){

            public Object get() {
                task.run();
                return null;
            }
        });
    }

    protected abstract <T> T as(Patient.ID var1, Supplier<T> var2);

    private String string(byte[] enciphered) {
        return new String(enciphered, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] marshal(byte[] bytes) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(77);
            out.write(bytes);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] unmarshal(byte[] bytes) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            out.write(bytes, 1, bytes.length - 1);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

