package be.recipe.api.timestamping;

import be.recipe.api.crypto.Message;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

import static java.nio.charset.StandardCharsets.UTF_8;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class SimpleTimestampingContextTest {
  private final SimpleTimestampingContext ctx = new SimpleTimestampingContext();

  @Test
  public void rejectExtractEncipheredBytes_fromNonCompacted() {
    assertThrows(
        Message.Encrypted.Timestamped.ExtractionFailed.class,
        new Executable() {
          @Override
          public void execute() throws Throwable {
            ctx.encrypted("x".getBytes(UTF_8));
          }
        });
  }

  @Test
  public void extractEncipheredBytes_fromCompacted() {
    assertEquals("x", new String(ctx.encrypted(ctx.compact("x".getBytes(UTF_8))), UTF_8));
  }
}
