package be.recipe.api.prescription;

import be.recipe.api.AbstractPrescriptionContentCipheringTest;
import be.recipe.api.Prescription;
import be.recipe.api.crypto.AESCipher;
import be.recipe.api.crypto.InmemKeyDB;
import be.recipe.api.crypto.Message;
import be.recipe.api.crypto.Message.Cipher.Key.Owner;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import java8.util.function.Supplier;

public class PrescriptionContentCipheringTest extends AbstractPrescriptionContentCipheringTest {
  private final AESCipher cipher = new AESCipher();
  private final InmemKeyDB db = new InmemKeyDB(cipher.toSpec());

  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  public Message.Cipher.Key.DB keyRegistry() {
    return db;
  }

  @Override
  public Message.Cipher cipher() {
    return cipher;
  }

  @Override
  protected <T> T as(Prescriber.Simple prescriber, Supplier<T> task) {
    return as((Owner<Prescription.OnContent>) prescriber, task);
  }

  public <T> T as(Owner<Prescription.OnContent> owner, Supplier<T> task) {
    db.owner = owner;
    return task.get();
  }

  @Override
  protected <T> T as(Executor.ID executor, Supplier<T> task) {
    return as((Owner<Prescription.OnContent>) executor, task);
  }

  @Override
  protected <T> T as(Patient.ID patient, Supplier<T> task) {
    return as((Owner<Prescription.OnContent>) patient, task);
  }
}
