package be.recipe.api.viewer;

import be.recipe.api.executor.Executor.ID;
import be.recipe.api.executor.Executor.Type;

import static be.recipe.api.executor.Executor.ID.executorId;
import static be.recipe.api.executor.Executor.Type.executorType;

// tag::class[]
public class ExecutorViewer implements be.recipe.api.executor.ExecutorViewer {
  // end::class[]
  // tag::attributes[]
  public final ID executor;
  public final Type type;
  // end::attributes[]

  public ExecutorViewer(ID executor, Type type) {
    this.executor = executor;
    this.type = type;
  }

  @Override
  public void visit(Visitor visitor) {
    visitor.on(this);
  }

  public static ExecutorViewer executor(ID id, Type type) {
    return new ExecutorViewer(id, type);
  }

  public static ExecutorViewer executor(String id, String type) {
    return executor(executorId(id), executorType(type));
  }
  // tag::class[]
}
// end::class[]
