package be.recipe.api.text;

import java8.util.function.Function;

public class ExtendableString implements CharSequence {
  private final String value;

  protected ExtendableString(String value) {
    if (value == null) throw new IllegalArgumentException("Must not be null!");
    if (value.trim().isEmpty()) throw new IllegalArgumentException("Must not be blank!");
    this.value = value;
  }

  @Override
  public int length() {
    return value.length();
  }

  @Override
  public char charAt(int index) {
    return value.charAt(index);
  }

  @Override
  public CharSequence subSequence(int start, int end) {
    return value.subSequence(start, end);
  }

  @Override
  public boolean equals(Object candidate) {
    if (candidate instanceof ExtendableString)
      return value.equals(((ExtendableString) candidate).value);
    else return false;
  }

  @Override
  public String toString() {
    return value;
  }

  public static <T extends ExtendableString> T construct(
      String value, Function<String, T> constructor) {
    return value == null || value.trim().isEmpty() ? null : constructor.apply(value);
  }
}
