package be.recipe.api.series;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

// tag::documented[]
public class Window {
  // tag::constraints[]
  @Min(value = 0, message = "lowerbound")
  public final int offset;

  @Min(value = 1, message = "lowerbound")
  @Max(value = 50, message = "upperbound")
  public final int count;
  // end::constraints[]
  // end::documented[]

  private Window(int offset, int count) {
    this.offset = offset;
    this.count = count;
  }

  public static Window offset(int offset) {
    return new Window(offset, 50);
  }

  public Window count(int count) {
    return new Window(offset, count);
  }

  public Window previous() {
    return offset == 0 ? this : offset(offset - count).count(count);
  }

  public Window next() {
    return offset(offset + count).count(count);
  }
  // tag::documented[]
}
// end::documented[]
