package be.recipe.api.series;

import static be.recipe.api.series.SortedBy.Order.ascending;

// tag::class[]
public class SortedBy<T extends Enum<?>> {
  public enum Order {
    ascending,
    descending
  }
  // end::class[]
  // tag::attributes[]

  public final T attribute;
  public final Order order;
  // end::attributes[]

  public static <T extends Enum<?>> SortedBy<T> sortedBy(T attribute) {
    return new SortedBy<>(attribute, ascending);
  }

  private SortedBy(T attribute, Order order) {
    this.attribute = attribute;
    this.order = order;
  }

  public SortedBy<T> order(Order order) {
    return new SortedBy<>(attribute, order);
  }
  // tag::class[]
}
// end::class[]
