package be.recipe.api.series;

import javax.validation.constraints.Min;

// tag::documented[]
public class Page {
  // tag::constraints[]
  @Min(value = 1, message = "lowerbound")
  public final int number;
  // end::constraints[]
  // end::documented[]

  private Page(int number) {
    this.number = number;
  }

  public static Page first() {
    return page(1);
  }

  public static Page page(int number) {
    return new Page(number);
  }

  public Page previous() {
    return number == 1 ? this : page(number - 1);
  }

  public Page next() {
    return page(number + 1);
  }

  public Window window() {
    Window window = Window.offset(0);
    for (int i = 1; i < number; i++)
      window = window.next();
    return window;
  }
  // tag::documented[]
}
// end::documented[]
