package be.recipe.api.reservation;

import be.recipe.api.executor.AcceptReservationCancellationRequest;
import be.recipe.api.patient.CancelReservation;
import be.recipe.api.patient.UpdateContactDetails;
import be.recipe.api.executor.ListReservations;
import be.recipe.api.patient.AddReservation;
import be.recipe.api.series.PartialResult;

public interface ReservationService<
        A extends AddReservation,
        AL extends AddReservation,
        ELR extends ListReservations.Request,
        CancelReservationAsPatient extends CancelReservation,
        CancelReservationAsPatientLegacy extends CancelReservation.Legacy,
        UCP extends UpdateContactDetails,
        AcceptReservation extends be.recipe.api.executor.AcceptReservation,
        RejectReservation extends be.recipe.api.executor.RejectReservation,
        CancelReservationAsExecutor extends AcceptReservationCancellationRequest,
        FulfillReservation extends be.recipe.api.executor.FulfillReservation>
    extends be.recipe.api.reservation.patient.ReservationService<
            A, AL, CancelReservationAsPatient, CancelReservationAsPatientLegacy, UCP>,
        be.recipe.api.reservation.executor.ReservationService<
            ELR,
            AcceptReservation,
            RejectReservation,
            CancelReservationAsExecutor,
            FulfillReservation> {
  interface Simplified
      extends ReservationService<
          AddReservation,
          AddReservation,
          ListReservations.Request,
          CancelReservation,
          CancelReservation.Legacy,
          UpdateContactDetails,
          be.recipe.api.executor.AcceptReservation,
          be.recipe.api.executor.RejectReservation,
      AcceptReservationCancellationRequest,
          be.recipe.api.executor.FulfillReservation> {
    class Router implements ReservationService.Simplified {
      private final be.recipe.api.reservation.executor.ReservationService.Simplified executor;
      private final be.recipe.api.reservation.patient.ReservationService.Simplified patient;

      public Router(
          be.recipe.api.reservation.executor.ReservationService.Simplified executor,
          be.recipe.api.reservation.patient.ReservationService.Simplified patient) {
        this.executor = executor;
        this.patient = patient;
      }

      @Override
      public PartialResult<Response> list(ListReservations.Request request) {
        return executor.list(request);
      }

      @Override
      public void add(AddReservation request) {
        patient.add(request);
      }

      @Override
      public void addLegacy(AddReservation request) {
        patient.addLegacy(request);
      }

      @Override
      public CancelReservation.Response update(CancelReservation request) {
        return patient.update(request);
      }

      @Override
      public void update(CancelReservation.Legacy request) {
        patient.update(request);
      }

      @Override
      public UpdateContactDetails.Response update(UpdateContactDetails request) {
        return patient.update(request);
      }

      @Override
      public void update(be.recipe.api.executor.AcceptReservation request) {
        executor.update(request);
      }

      @Override
      public void update(be.recipe.api.executor.RejectReservation request) {
        executor.update(request);
      }

      @Override
      public void update(AcceptReservationCancellationRequest request) {
        executor.update(request);
      }

      @Override
      public void update(be.recipe.api.executor.FulfillReservation request) {
        executor.update(request);
      }
    }
  }
}
