package be.recipe.api.reservation;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ContactPreference {
    NO_PREFERENCE, EMAIL_ADDRESS, TELEPHONE_NUMBER;

    private static final Map<Integer, ContactPreference> lookup = new HashMap<>();

    static {
        for (ContactPreference contactPreference : EnumSet.allOf(ContactPreference.class)) {
            lookup.put(contactPreference.ordinal(), contactPreference);
        }
    }

    public static ContactPreference get(int code) {
        return lookup.get(code);
    }
}
