package be.recipe.api.projections;

import be.recipe.api.prescriber.Prescriber.ID;
import be.recipe.api.prescriber.PrescriberType;

// tag::search-result[]
public interface SearchResult {
  // end::search-result[]
  // tag::prescriber[]
  interface Prescriber {
    ID id();

    PrescriberType type();
    // end::prescriber[]

    class Simple implements Prescriber {
      private final PrescriberType type;
      protected ID id;

      public static Simple type(PrescriberType type) {
        return new Simple(type);
      }

      public Simple(PrescriberType type) {
        this.type = type;
      }

      public Simple id(ID id) {
        this.id = id;
        return this;
      }

      @Override
      public ID id() {
        return id;
      }

      @Override
      public PrescriberType type() {
        return type;
      }
    }
    // tag::prescriber[]
  }
  // end::prescriber[]
  // tag::search-result[]
}
// end::search-result[]
