package be.recipe.api.prescriber;

import be.recipe.api.Prescription;
import be.recipe.api.constraints.Constraint;

import javax.validation.constraints.NotNull;

// tag::class[]
public class RevokePrescription {
  // end::class[]
  // tag::attributes[]
  @NotNull(message = Constraint.required)
  public Prescription.RID rid;
  // end::attributes[]

  public static RevokePrescription of(Prescription.RID rid) {
    return new RevokePrescription().rid(rid);
  }

  private RevokePrescription rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }
  // tag::feature[]

  public interface Command<Request extends RevokePrescription> {
    void update(Request request);
  }
  // end::feature[]
  // tag::class[]
}
// end::class[]
