package be.recipe.api.prescriber;

import be.recipe.api.Prescription;
import be.recipe.api.constraints.Known;

import static be.recipe.api.Prescription.not_found;

// tag::class[]
public class GetPrescription {
  // end::class[]
  // tag::attributes[]
  @Known(message = not_found)
  public Prescription.RID rid;
  // end::attributes[]

  public static GetPrescription of(Prescription.RID prescription) {
    return new GetPrescription(prescription);
  }

  protected GetPrescription(Prescription.RID rid) {
    this.rid = rid;
  }
  // tag::feature[]

  public interface Command<Request extends GetPrescription, Response extends Prescription> {
    Response get(Request request);
  }
  // end::feature[]
  // tag::class[]
}
// end::class[]
