package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.reservation.ContactPreference;

import javax.validation.constraints.NotNull;

// tag::class[]
public class UpdateContactDetails {
  // end::class[]

  String illegal_access = "illegal.access.update.contactdetails";

  // tag::attributes[]
  @NotNull public Prescription.RID rid;
  public String email;
  public String phoneNumber;
  public ContactPreference contactPreference;

  // end::attributes[]

  protected UpdateContactDetails(Prescription.RID rid) {
    this.rid = rid;
  }

  protected UpdateContactDetails(Prescription.RID rid, String email, String phoneNumber, ContactPreference contactPreference) {
    this.rid = rid;
    this.email = email;
    this.phoneNumber = phoneNumber;
    this.contactPreference = contactPreference;
  }

  public static UpdateContactDetails of(Prescription.RID rid) {
    return new UpdateContactDetails(rid);
  }

  private UpdateContactDetails rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }

  public UpdateContactDetails email(String email) {
    this.email = email;
    return this;
  }

  public UpdateContactDetails phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  public UpdateContactDetails contactPreference(ContactPreference contactPreference) {
    this.contactPreference = contactPreference;
    return this;
  }

  // tag::class[]
  public interface Command<Request extends UpdateContactDetails> {
    // end::class[]
    // tag::methods[]
    Response update(Request request);
    // end::methods[]
    // tag::class[]
  }

  public interface Response {}
}
// end::class[]
