package be.recipe.api.patient;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::class[]
public class UnlockPrescription {
  // end::class[]
  // tag::attributes[]
  @NotNull public Prescription.RID prescription;

  // end::attributes[]
  public UnlockPrescription() {}

  private UnlockPrescription(Prescription.RID prescription) {
    this.prescription = prescription;
  }

  public static UnlockPrescription unlock(Prescription.RID prescription) {
    return new UnlockPrescription(prescription);
  }

  // tag::class[]
  public interface Command<R extends UnlockPrescription> {
    // end::class[]
    // tag::methods[]
    void unlock(UnlockPrescription request);
    // end::methods[]
    // tag::class[]
  }
}
// end::class[]
