package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.patient.constraints.CompatibleWithReservation;

import javax.validation.constraints.NotNull;

// tag::class[]
public interface PutVisionExecutors<R extends PutVisionExecutors.Request> {
  // end::class[]
  // tag::methods[]
  void update(R request);

  // end::methods[]
  // tag::class[]
  @CompatibleWithReservation
  class Request {
    // end::class[]
    // tag::attributes[]
    @NotNull public Prescription.RID prescription;
    @NotNull public ExecutorViewer viewer;
    // end::attributes[]
    // tag::class[]
  }
}
// end::class[]
