package be.recipe.api.patient;

import static be.recipe.api.viewer.AllViewer.all;
import static be.recipe.api.viewer.PatientViewer.patient;

public class Dispatcher {
  public static void lock(LockPrescription.Request from, PutVisionExecutors<PutVisionExecutors.Request> target) {
    PutVisionExecutors.Request to = new PutVisionExecutors.Request();
    to.prescription = from.prescription;
    to.viewer = patient();
    target.update(to);
  }

  public static void unlock(UnlockPrescription from, PutVisionExecutors<PutVisionExecutors.Request> target) {
    PutVisionExecutors.Request to = new PutVisionExecutors.Request();
    to.prescription = from.prescription;
    to.viewer = all();
    target.update(to);
  }
}
