package be.recipe.api.mandate;

import be.recipe.api.patient.Patient;

public interface Mandate {
  MandateGiver mandateGiver();

  Patient.ID mandateHolder();

  Type type();

  enum Type {
    GMH("general"),
    RMH("recipe"),
    PMH("parent");

    private final String fluentName;

    Type(String fluentName) {
      this.fluentName = fluentName;
    }

    public String fluentName() {
      return fluentName;
    }

    public static Type of(String fluentName) {
      for (Type type : values()) if (type.fluentName.equals(fluentName)) return type;
      throw new IllegalArgumentException("Unknown mandate type! [" + fluentName + "]");
    }
  }

  class Simple implements Mandate {
    private MandateGiver mandateGiver;
    private Patient.ID mandateHolder;
    private Type type;

    public static Simple mandate() {
      return new Simple();
    }

    public Simple mandateGiver(MandateGiver mandateGiver) {
      this.mandateGiver = mandateGiver;
      return this;
    }

    public Simple mandateHolder(Patient.ID mandateHolder) {
      this.mandateHolder = mandateHolder;
      return this;
    }

    @Override
    public Patient.ID mandateHolder() {
      return mandateHolder;
    }

    @Override
    public Type type() {
      return type;
    }

    @Override
    public MandateGiver mandateGiver() {
      return mandateGiver;
    }

    public Simple type(Type type) {
      this.type = type;
      return this;
    }
  }

  class Wrapper implements Mandate {
    private final Mandate target;

    public Wrapper(Mandate target) {
      this.target = target;
    }

    @Override
    public MandateGiver mandateGiver() {
      return target.mandateGiver();
    }

    @Override
    public Patient.ID mandateHolder() {
      return target.mandateHolder();
    }

    @Override
    public Type type() {
      return target.type();
    }
  }
}
