package be.recipe.api.executor;

import static be.recipe.api.constraints.Constraint.required;

import be.recipe.api.ExecutorProfile;
import javax.validation.constraints.NotNull;

// tag::feature[]
public class UpdateProfile {
  @NotNull(message = required)
  private ExecutorProfile.ReservationFeature reservationFeature;

  @NotNull(message = required)
  private ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification;
  // end::feature[]

  protected UpdateProfile() {}

  protected UpdateProfile(UpdateProfile target) {
    reservationFeature = target.reservationFeature();
    communicationChannelSpecification = target.communicationChannelSpecification();
  }

  public ExecutorProfile.ReservationFeature reservationFeature() {
    return reservationFeature;
  }

  public UpdateProfile reservationFeature(ExecutorProfile.ReservationFeature reservationFeature) {
    this.reservationFeature = reservationFeature;
    return this;
  }

  public ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification() {
    return communicationChannelSpecification;
  }

  public UpdateProfile communicationChannelSpecification(
      ExecutorProfile.CommunicationChannelSpecification communicationChannelSpecification) {
    this.communicationChannelSpecification = communicationChannelSpecification;
    return this;
  }

  // tag::feature[]

  public interface Command<Request extends UpdateProfile> {
    void updateProfile(Request request);
  }

  // end::feature[]

  public static UpdateProfile request() {
    return new UpdateProfile();
  }
  // tag::feature[]
}
// end::feature[]
