package be.recipe.api.executor;

import static be.recipe.api.constraints.Constraint.required;

import be.recipe.api.mandate.Mandate;
import be.recipe.api.mandate.MandateGiver;
import be.recipe.api.patient.Patient;
import java8.util.stream.Stream;
import javax.validation.constraints.NotNull;

public class ListMandatesByMandateHolder {
  @NotNull(message = required)
  public final Patient.ID mandateHolder;

  protected ListMandatesByMandateHolder(Patient.ID mandateHolder) {
    this.mandateHolder = mandateHolder;
  }

  public static ListMandatesByMandateHolder requestByMandateHolder(Patient.ID mandateHolder) {
    return new ListMandatesByMandateHolder(mandateHolder);
  }

  public interface Command<
      Request extends ListMandatesByMandateHolder,
      Response extends ListMandatesByMandateHolder.Response> {
    Stream<Response> listMandates(Request request);
  }

  public interface Response {
    MandateGiver mandateGiver();

    Mandate.Type type();

    class Simple implements Response {
      private MandateGiver mandateGiver;
      private Mandate.Type type;

      public static Simple mandate(Mandate.Type type) {
        return new Simple().type(type);
      }

      public Simple type(Mandate.Type type) {
        this.type = type;
        return this;
      }

      public Simple mandateGiver(MandateGiver mandateGiver) {
        this.mandateGiver = mandateGiver;
        return this;
      }

      @Override
      public MandateGiver mandateGiver() {
        return mandateGiver;
      }

      @Override
      public Mandate.Type type() {
        return type;
      }
    }
  }
}
