package be.recipe.api.executor;

import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Prescription;

// tag::class[]
public class GetPrescriptionStatus {
  // end::class[]
  // tag::attributes[]
  public final Prescription.RID rid;

  // end::attributes[]
  public GetPrescriptionStatus(Prescription.RID rid) {
    this.rid = rid;
  }

  public static GetPrescriptionStatus of(Prescription.RID prescription) {
    return new GetPrescriptionStatus(prescription);
  }

  // tag::class[]
  public interface Command<
      Request extends GetPrescriptionStatus, Response extends GetPrescriptionStatusResponse> {
    Response get(Request request);
  }
}
// end::class[]
