package be.recipe.api.executor;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::class[]
public class GetPrescription {

  @NotNull
  public Prescription.RID rid;
  protected GetPrescription(Prescription.RID rid)  {
    this.rid = rid;
  }

  public static GetPrescription of(Prescription.RID rid) {
    return new GetPrescription(rid);
  }

  // tag::feature[]

  public interface Command<Request extends GetPrescription, Response extends Prescription> {
    Response get(Request request);
  }
}
// end::class[]
