package be.recipe.api.executor;

public class BreakTheGlass {
  public enum Reason {
    UNABLE_TO_CHECK_THERAPEUTIC_RELATION,
    UNABLE_TO_CREATE_THERAPEUTIC_RELATION,
    OTHER_REASON
  }

  private final Reason reason;
  private String description;

  private BreakTheGlass(Reason reason) {
    this.reason = reason;
  }

  public static BreakTheGlass reason(Reason reason) {
    return new BreakTheGlass(reason);
  }

  public Reason reason() {
    return reason;
  }

  public String description() {
    return description;
  }

  public BreakTheGlass description(String description) {
    this.description = description;
    return this;
  }
}
