package be.recipe.api.executor;

import be.recipe.api.Prescription;

import javax.validation.constraints.NotNull;

// tag::class[]
public class ArchivePrescription {
  // end::class[]
  // tag::attributes[]
  @NotNull public final Prescription.RID rid;
  // end::attributes[]

  protected ArchivePrescription(Prescription.RID rid) {
    this.rid = rid;
  }

  public static ArchivePrescription of(Prescription.RID rid) {
    return new ArchivePrescription(rid);
  }
  // tag::feature[]

  public interface Command<R extends ArchivePrescription> {
    void update(R request);
  }
  // end::feature[]
  // tag::class[]
}
// end::class[]
