package be.recipe.api.executor;

import be.recipe.api.Prescription;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

// tag::feature[]
public class AcceptReservation {
  @NotNull public Prescription.RID rid;

  @Size(max = 500)
  public String message;
  // end::feature[]

  public static AcceptReservation of(Prescription.RID rid) {
    return new AcceptReservation().rid(rid);
  }

  public static AcceptReservation of(Prescription.RID rid, String message) {
    return new AcceptReservation().rid(rid).message(message);
  }

  public AcceptReservation rid(Prescription.RID rid) {
    this.rid = rid;
    return this;
  }

  public AcceptReservation message(String message) {
    this.message = message;
    return this;
  }
  // tag::feature[]

  public interface Command<Request extends AcceptReservation> {
    void update(Request request);
  }
}
// end::feature[]
