package be.recipe.api.crypto;

import java8.util.function.Function;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESCipher implements Message.Cipher {
  private final AES target = new AES();

  @Override
  public byte[] encrypt(byte[] decryptedMessage, Key key) {
    return target.encrypt(decryptedMessage, key.secret());
  }

  @Override
  public byte[] decrypt(byte[] encryptedMessage, Key key) {
    return target.decrypt(encryptedMessage, key.secret());
  }

  public SecretKeySpec spec(byte[] it) {
    return target.spec(it);
  }

  public Function<byte[], SecretKey> toSpec() {
    return new Function<byte[], SecretKey>() {
      @Override
      public SecretKey apply(byte[] bytes) {
        return spec(bytes);
      }
    };
  }
}
