package be.recipe.api;

import be.recipe.api.crypto.Message;
import be.recipe.api.executor.GetPrescription;
import be.recipe.api.executor.GetPrescriptionAndPutInProcess;

public class ArchivingPrescriptionService extends PrescriptionService.Simplified.Wrapper {
  private final PrescriptionContent.Factory prescriptionContentFactory;
  private final Message.Encrypted.Timestamped.Extractor extractor;

  public ArchivingPrescriptionService(
      Simplified target,
      Message.Encrypted.Timestamped.Extractor extractor,
      PrescriptionContent.Factory prescriptionContentFactory) {
    super(target);
    this.extractor = extractor;
    this.prescriptionContentFactory = prescriptionContentFactory;
  }

  @Override
  public Prescription.Encrypted get(GetPrescription request) {
    return new ArchivingPrescription(super.get(request));
  }

  @Override
  public Prescription.Encrypted getAndPutInProcess(GetPrescriptionAndPutInProcess request) {
    return new ArchivingPrescription(super.getAndPutInProcess(request));
  }

  private class ArchivingPrescription extends Prescription.Encrypted.Wrapper {
    public ArchivingPrescription(Encrypted target) {
      super(target);
    }

    @Override
    public byte[] encryptedContent() {
      if (super.encryptedContent() == null) return null;
      try {
        return extractor.encrypted(super.encryptedContent());
      } catch (Message.Encrypted.Timestamped.ExtractionFailed ignored) {
        return super.encryptedContent();
      }
    }
  }
}
