/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.time;

import java.util.Objects;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoLocalDate;

public class LocalDateRange {
    private final LocalDate start;
    private final LocalDate end;

    public static LocalDateRange of(LocalDate start, LocalDate end) {
        return new LocalDateRange(start, end);
    }

    public static LocalDateRange ofClosed(LocalDate start, LocalDate end) {
        return LocalDateRange.of(start, end.plusDays(1L));
    }

    private LocalDateRange(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public LocalDate getEndInclusive() {
        return this.end.minusDays(1L);
    }

    public boolean contains(LocalDate dt) {
        return !dt.isBefore((ChronoLocalDate)this.start) && dt.isBefore((ChronoLocalDate)this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalDateRange)) {
            return false;
        }
        LocalDateRange that = (LocalDateRange)o;
        return this.start.equals((Object)that.start) && this.end.equals((Object)that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "LocalDateRange{start=" + this.start + ", end=" + this.end + '}';
    }
}

