/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.text;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public class LocalisedMessage {
    private final Locale locale;
    private final String value;

    private LocalisedMessage(Locale locale, String value) {
        this.locale = locale;
        this.value = value;
    }

    public static Context context(String id, Locale ... locales) {
        return new Context(id, Arrays.asList(locales));
    }

    public static LocalisedMessage message(Locale locale, String value) {
        return new LocalisedMessage(locale, value);
    }

    public Locale locale() {
        return this.locale;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return "[" + this.locale + "] " + this.value;
    }

    public static class Context {
        private final List<Locale> locales;
        private final String id;

        public Context(String id, List<Locale> locales) {
            this.id = id;
            this.locales = locales;
        }

        public String id() {
            return this.id;
        }

        public Stream<Locale> locales() {
            return StreamSupport.stream(this.locales);
        }
    }
}

