/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.series;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java8.util.function.Function;
import java8.util.function.Predicate;
import java8.util.function.Supplier;
import java8.util.stream.Collector;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public interface PartialResult<T> {
    public Stream<T> stream();

    public List<T> list();

    public boolean hasMore();

    public PartialResult<T> filter(Predicate<? super T> var1);

    public <C> PartialResult<C> map(Function<? super T, ? extends C> var1);

    public <R, A> R collect(Collector<? super T, A, R> var1);

    public static class Wrapper<T>
    implements PartialResult<T> {
        private final PartialResult<T> target;

        public Wrapper(PartialResult<T> target) {
            this.target = target;
        }

        @Override
        public Stream<T> stream() {
            return this.target.stream();
        }

        @Override
        public List<T> list() {
            return (List)this.target.stream().collect(Collectors.toList());
        }

        @Override
        public boolean hasMore() {
            return this.target.hasMore();
        }

        @Override
        public PartialResult<T> filter(final Predicate<? super T> predicate) {
            return Simple.of(new Supplier<Stream<T>>(){

                public Stream<T> get() {
                    return this.stream().filter(predicate);
                }
            }).hasMore(this.hasMore());
        }

        @Override
        public <C> PartialResult<C> map(final Function<? super T, ? extends C> transformer) {
            return Simple.of(new Supplier<Stream<C>>(){

                public Stream<C> get() {
                    return this.stream().map(transformer);
                }
            }).hasMore(this.hasMore());
        }

        @Override
        public <R, A> R collect(Collector<? super T, A, R> collector) {
            return (R)this.stream().collect(collector);
        }
    }

    public static class Simple<T>
    implements PartialResult<T> {
        private final Supplier<Stream<T>> supplier;
        private boolean hasMore;

        public static <T> Simple<T> of(Supplier<Stream<T>> supplier) {
            return new Simple<T>(supplier);
        }

        @SafeVarargs
        public static <T> Simple<T> of(final T ... it) {
            return new Simple<T>(new Supplier<Stream<T>>(){

                public Stream<T> get() {
                    return StreamSupport.stream(Arrays.asList(it));
                }
            });
        }

        public static <T> PartialResult<T> empty() {
            return new Simple<T>(new Supplier<Stream<T>>(){

                public Stream<T> get() {
                    return StreamSupport.stream(Collections.emptyList());
                }
            });
        }

        public static <T> PartialResult<T> buffered(PartialResult<T> it) {
            final List buffer = (List)it.stream().collect(Collectors.toList());
            return Simple.of(new Supplier<Stream<T>>(){

                public Stream<T> get() {
                    return StreamSupport.stream((Collection)buffer);
                }
            }).hasMore(it.hasMore());
        }

        public Simple(Supplier<Stream<T>> supplier) {
            this.supplier = supplier;
        }

        public PartialResult<T> hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        @Override
        public Stream<T> stream() {
            return (Stream)this.supplier.get();
        }

        @Override
        public List<T> list() {
            return (List)((Stream)this.supplier.get()).collect(Collectors.toList());
        }

        @Override
        public boolean hasMore() {
            return this.hasMore;
        }

        @Override
        public <C> PartialResult<C> map(final Function<? super T, ? extends C> transformer) {
            return Simple.of(new Supplier<Stream<C>>(){

                public Stream<C> get() {
                    return this.stream().map(transformer);
                }
            }).hasMore(this.hasMore);
        }

        @Override
        public PartialResult<T> filter(final Predicate<? super T> predicate) {
            return Simple.of(new Supplier<Stream<T>>(){

                public Stream<T> get() {
                    return this.stream().filter(predicate);
                }
            }).hasMore(this.hasMore);
        }

        @Override
        public <R, A> R collect(Collector<? super T, A, R> collector) {
            return (R)this.stream().collect(collector);
        }
    }
}

