/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescriber;

import be.recipe.api.Prescription;
import be.recipe.api.prescriber.ListPrescriptions;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.projections.SearchResult;
import org.threeten.bp.LocalDate;

abstract class PrescriptionWrapper<T extends Prescription>
implements ListPrescriptions.Response {
    protected final T target;

    PrescriptionWrapper(T target) {
        this.target = target;
    }

    @Override
    public Prescription.RID rid() {
        return this.target.rid();
    }

    @Override
    public Prescription.Status status() {
        return this.target.status();
    }

    @Override
    public SearchResult.Prescriber prescriber() {
        return this.target.prescriber();
    }

    @Override
    public LocalDate creationDate() {
        return this.target.creationDate().toLocalDate();
    }

    @Override
    public LocalDate expirationDate() {
        return this.target.expirationDate();
    }

    @Override
    public VisionOtherPrescribers visionOtherPrescribers() {
        return this.target.visionOtherPrescribers();
    }

    public static class Encrypted
    extends PrescriptionWrapper<Prescription.Encrypted>
    implements ListPrescriptions.Response.Encrypted {
        public Encrypted(Prescription.Encrypted prescription) {
            super(prescription);
        }

        @Override
        public byte[] encryptedPrescriptionContent() {
            return ((Prescription.Encrypted)this.target).encryptedContent();
        }

        @Override
        public String encryptionKey() {
            return ((Prescription.Encrypted)this.target).encryptionKey();
        }
    }
}

