/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.prescriber;

import be.recipe.api.Actor;
import be.recipe.api.Prescription;
import be.recipe.api.SSIN;
import be.recipe.api.crypto.Message;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.projections.SearchResult;
import java8.util.function.Function;

public interface Prescriber
extends SearchResult.Prescriber {
    @Override
    public ID id();

    public SSIN ssin();

    @Override
    public PrescriberType type();

    public static class Wrapper
    implements Prescriber {
        private final Prescriber target;

        public Wrapper(Prescriber target) {
            this.target = target;
        }

        @Override
        public ID id() {
            return this.target.id();
        }

        @Override
        public SSIN ssin() {
            return this.target.ssin();
        }

        @Override
        public PrescriberType type() {
            return this.target.type();
        }
    }

    public static class Simple
    implements Prescriber,
    Message.Cipher.Key.Owner<Prescription.OnContent> {
        private final ID id;
        private final PrescriberType type;
        public SSIN ssin;

        public static Simple prescriber(PrescriberType type, ID id) {
            return new Simple(id, type);
        }

        public Simple(ID id, PrescriberType type) {
            this.id = id;
            this.type = type;
        }

        public Simple(ID id, PrescriberType type, SSIN ssin) {
            this.id = id;
            this.type = type;
            this.ssin = ssin;
        }

        @Override
        public ID id() {
            return this.id;
        }

        @Override
        public SSIN ssin() {
            return this.ssin;
        }

        @Override
        public PrescriberType type() {
            return this.type;
        }

        @Override
        public void process(Prescription.OnContent processor) {
            processor.process(this);
        }
    }

    public static class ID
    extends Actor.ID {
        protected ID(String value) {
            super(value);
        }

        public static ID prescriberID(String id) {
            return ID.construct(id, new Function<String, ID>(){

                public ID apply(String it) {
                    return new ID(it);
                }
            });
        }
    }
}

