/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.patient;

import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.Registered;
import be.recipe.api.executor.Executor;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.patient.AbstractSimpleResponse;
import be.recipe.api.patient.Patient;
import be.recipe.api.patient.PrescriptionWrapper;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.reservation.ContactPreference;
import be.recipe.api.reservation.Reservation;
import be.recipe.api.reservation.Reserved;
import be.recipe.api.series.Page;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.SortedBy;
import java8.util.Optional;
import java8.util.function.Function;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public class ListPrescriptions {
    public Reserved reserved;
    @Valid
    @NotNull(message="required")
    public @Valid @NotNull(message="required") Page page = Page.first();
    public SortedBy<Prescription.Attribute>[] sortedBy;

    public ListPrescriptions() {
    }

    public ListPrescriptions(Page page) {
        this.page = page;
    }

    public ListPrescriptions(Reserved reserved) {
        this.reserved = reserved;
    }

    public ListPrescriptions(SortedBy<Prescription.Attribute>[] sortedBy) {
        this.sortedBy = sortedBy.length == 0 ? null : sortedBy;
    }

    public ListPrescriptions(Page page, Reserved reserved, SortedBy<Prescription.Attribute>[] sortedBy) {
        this.reserved = reserved;
        this.page = page;
        this.sortedBy = sortedBy == null || sortedBy.length == 0 ? null : sortedBy;
    }

    public static interface Response
    extends Registered {
        public Patient.ID patient();

        public Prescriber.ID prescriber();

        public Prescription.Type type();

        public LocalDate expirationDate();

        public boolean feedbackAllowed();

        public ExecutorViewer visibleToExecutors();

        public VisionOtherPrescribers visionOtherPrescribers();

        public Prescription.Status status();

        public LocalDateTime creationDate();

        public Optional<Reservation> reservation();

        public static abstract class AbstractWrapper<T extends Response>
        implements Response {
            final T target;

            public AbstractWrapper(T target) {
                this.target = target;
            }

            @Override
            public Prescription.RID rid() {
                return this.target.rid();
            }

            @Override
            public Prescription.Type type() {
                return this.target.type();
            }

            @Override
            public Patient.ID patient() {
                return this.target.patient();
            }

            @Override
            public Prescriber.ID prescriber() {
                return this.target.prescriber();
            }

            @Override
            public LocalDateTime creationDate() {
                return this.target.creationDate();
            }

            @Override
            public LocalDate expirationDate() {
                return this.target.expirationDate();
            }

            @Override
            public ExecutorViewer visibleToExecutors() {
                return this.target.visibleToExecutors();
            }

            @Override
            public VisionOtherPrescribers visionOtherPrescribers() {
                return this.target.visionOtherPrescribers();
            }

            @Override
            public Prescription.Status status() {
                return this.target.status();
            }

            @Override
            public boolean feedbackAllowed() {
                return this.target.feedbackAllowed();
            }

            @Override
            public Optional<Reservation> reservation() {
                return this.target.reservation();
            }
        }

        public static interface Encrypted
        extends Response {
            public byte[] encryptedPrescriptionContent();

            public String encryptionKey();

            public static class Wrapper
            extends AbstractWrapper<Encrypted>
            implements Encrypted {
                public Wrapper(Encrypted target) {
                    super(target);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return ((Encrypted)this.target).encryptedPrescriptionContent();
                }

                @Override
                public String encryptionKey() {
                    return ((Encrypted)this.target).encryptionKey();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements Encrypted {
                public byte[] encryptedPrescriptionContent;
                public String encryptionKey;

                public static Simple response(Prescription.RID rid) {
                    Simple it = new Simple();
                    it.rid = rid;
                    return it;
                }

                public static Encrypted response(Prescription.Encrypted encrypted) {
                    return new PrescriptionWrapper(encrypted);
                }

                @Override
                public byte[] encryptedPrescriptionContent() {
                    return this.encryptedPrescriptionContent;
                }

                @Override
                public String encryptionKey() {
                    return this.encryptionKey;
                }

                public Simple prescriptionContent(PrescriptionContent.Encrypted it) {
                    this.encryptionKey = it.key().toString();
                    this.encryptedPrescriptionContent = it.bytes();
                    return this;
                }

                public PlainText.Simple prescriptionContent(String prescriptionContent) {
                    return new PlainText.Simple(this).prescriptionContent(prescriptionContent);
                }
            }
        }

        public static interface PlainText
        extends Response {
            public String prescriptionContent();

            public static class Wrapper
            extends AbstractWrapper<PlainText>
            implements PlainText {
                public Wrapper(PlainText target) {
                    super(target);
                }

                @Override
                public String prescriptionContent() {
                    return ((PlainText)this.target).prescriptionContent();
                }
            }

            public static class Simple
            extends AbstractSimpleResponse
            implements PlainText {
                public String prescriptionContent;

                public Simple(Encrypted from) {
                    super(from);
                }

                @Override
                public String prescriptionContent() {
                    return this.prescriptionContent;
                }

                public Simple prescriptionContent(String prescriptionContent) {
                    this.prescriptionContent = prescriptionContent;
                    return this;
                }

                public static Function<PlainText, String> toPrescriptionContent() {
                    return new Function<PlainText, String>(){

                        public String apply(PlainText it) {
                            return it.prescriptionContent();
                        }
                    };
                }
            }
        }

        public static interface Reservation {
            public Executor.ID executorId();

            public Reservation.Status status();

            public LocalDateTime creationDateTime();

            public boolean hasUpdates();

            public String feedbackToPatient();

            public String email();

            public String phoneNumber();

            public ContactPreference contactPreference();

            public static class Simple
            implements Reservation {
                public Executor.ID executorId;
                public LocalDateTime creationDateTime;
                public ContactPreference contactPreference;
                public String feedbackToPatient;
                public String email;
                public String phoneNumber;
                public boolean hasUpdates;
                public Reservation.Status status;

                @Override
                public Executor.ID executorId() {
                    return this.executorId;
                }

                @Override
                public Reservation.Status status() {
                    return this.status;
                }

                @Override
                public LocalDateTime creationDateTime() {
                    return this.creationDateTime;
                }

                @Override
                public boolean hasUpdates() {
                    return this.hasUpdates;
                }

                @Override
                public String feedbackToPatient() {
                    return this.feedbackToPatient;
                }

                @Override
                public String email() {
                    return this.email;
                }

                @Override
                public String phoneNumber() {
                    return this.phoneNumber;
                }

                @Override
                public ContactPreference contactPreference() {
                    return this.contactPreference;
                }
            }
        }
    }

    public static interface Command<Request extends ListPrescriptions, Response extends Response> {
        public PartialResult<Response> list(Request var1);
    }
}

