/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.mandate;

import be.recipe.api.mandate.MandateGiver;
import be.recipe.api.patient.Patient;

public interface Mandate {
    public MandateGiver mandateGiver();

    public Patient.ID mandateHolder();

    public Type type();

    public static class Wrapper
    implements Mandate {
        private final Mandate target;

        public Wrapper(Mandate target) {
            this.target = target;
        }

        @Override
        public MandateGiver mandateGiver() {
            return this.target.mandateGiver();
        }

        @Override
        public Patient.ID mandateHolder() {
            return this.target.mandateHolder();
        }

        @Override
        public Type type() {
            return this.target.type();
        }
    }

    public static class Simple
    implements Mandate {
        private MandateGiver mandateGiver;
        private Patient.ID mandateHolder;
        private Type type;

        public static Simple mandate() {
            return new Simple();
        }

        public Simple mandateGiver(MandateGiver mandateGiver) {
            this.mandateGiver = mandateGiver;
            return this;
        }

        public Simple mandateHolder(Patient.ID mandateHolder) {
            this.mandateHolder = mandateHolder;
            return this;
        }

        @Override
        public Patient.ID mandateHolder() {
            return this.mandateHolder;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public MandateGiver mandateGiver() {
            return this.mandateGiver;
        }

        public Simple type(Type type) {
            this.type = type;
            return this;
        }
    }

    public static enum Type {
        GMH("general"),
        RMH("recipe"),
        PMH("parent");

        private final String fluentName;

        private Type(String fluentName) {
            this.fluentName = fluentName;
        }

        public String fluentName() {
            return this.fluentName;
        }

        public static Type of(String fluentName) {
            for (Type type : Type.values()) {
                if (!type.fluentName.equals(fluentName)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown mandate type! [" + fluentName + "]");
        }
    }
}

