/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.executor;

import be.recipe.api.Prescription;
import be.recipe.api.Registered;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.executor.ListPrescriptions;
import be.recipe.api.executor.ReservationWrapper;
import be.recipe.api.reservation.ContactPreference;
import be.recipe.api.reservation.Reservation;
import be.recipe.api.series.Page;
import be.recipe.api.series.PartialResult;
import be.recipe.api.series.SortedBy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java8.util.function.Function;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.threeten.bp.LocalDateTime;

public interface ListReservations<R extends Request> {
    public PartialResult<Response> list(R var1);

    public static interface Response
    extends Registered {
        public ExecutorViewer visibleTo();

        public Reservation.Status status();

        public LocalDateTime createdOn();

        public LocalDateTime updatedOn();

        public String email();

        public String phoneNumber();

        public ContactPreference contactPreference();

        public ListPrescriptions.Response.Encrypted prescription();

        public static class Wrapper
        implements Response {
            private final Response target;

            public static Response response(Response target) {
                return new Wrapper(target);
            }

            protected Wrapper(Response target) {
                this.target = target;
            }

            @Override
            public Prescription.RID rid() {
                return this.target.rid();
            }

            @Override
            public ExecutorViewer visibleTo() {
                return this.target.visibleTo();
            }

            @Override
            public Reservation.Status status() {
                return this.target.status();
            }

            @Override
            public LocalDateTime createdOn() {
                return this.target.createdOn();
            }

            @Override
            public LocalDateTime updatedOn() {
                return this.target.updatedOn();
            }

            @Override
            public String email() {
                return this.target.email();
            }

            @Override
            public String phoneNumber() {
                return this.target.phoneNumber();
            }

            @Override
            public ContactPreference contactPreference() {
                return this.target.contactPreference();
            }

            @Override
            public ListPrescriptions.Response.Encrypted prescription() {
                return this.target.prescription();
            }
        }

        public static class Simple
        implements Response {
            public ExecutorViewer visibleTo;
            public Prescription.RID rid;
            public ListPrescriptions.Response.Encrypted prescription;
            public Reservation.Status reservationStatus;
            public ContactPreference contactPreference;
            public LocalDateTime createdOn;
            public LocalDateTime updatedOn;
            public String email;
            public String phoneNumber;

            public static Response response(Reservation target) {
                return new ReservationWrapper(target);
            }

            @Override
            public Prescription.RID rid() {
                return this.rid;
            }

            @Override
            public ExecutorViewer visibleTo() {
                return this.visibleTo;
            }

            @Override
            public Reservation.Status status() {
                return this.reservationStatus;
            }

            @Override
            public LocalDateTime createdOn() {
                return this.createdOn;
            }

            @Override
            public LocalDateTime updatedOn() {
                return this.updatedOn;
            }

            @Override
            public String email() {
                return this.email;
            }

            @Override
            public String phoneNumber() {
                return this.phoneNumber;
            }

            @Override
            public ContactPreference contactPreference() {
                return this.contactPreference;
            }

            @Override
            public ListPrescriptions.Response.Encrypted prescription() {
                return this.prescription;
            }
        }
    }

    public static class Request {
        @Valid
        @NotNull(message="required")
        public @Valid @NotNull(message="required") Page page = Page.first();
        public SortedBy<Reservation.Attribute>[] sortedBy;

        public static Request request() {
            return new Request();
        }

        public Request sortedBy(SortedBy<Reservation.Attribute> sortedBy) {
            this.sortedBy = ((List)StreamSupport.stream(Arrays.asList(StreamSupport.stream(Collections.singleton(sortedBy)), this.sortedBy == null ? StreamSupport.stream(Collections.emptyList()) : StreamSupport.stream(Arrays.asList(this.sortedBy)))).flatMap((Function)new Function<Stream<SortedBy<Reservation.Attribute>>, Stream<SortedBy<Reservation.Attribute>>>(){

                public Stream<SortedBy<Reservation.Attribute>> apply(Stream<SortedBy<Reservation.Attribute>> sortedByStream) {
                    return sortedByStream;
                }
            }).collect(Collectors.toList())).toArray(new SortedBy[0]);
            return this;
        }
    }
}

