/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.crypto;

import be.recipe.api.text.ExtendableString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java8.util.function.Function;
import java8.util.function.Predicate;
import javax.crypto.SecretKey;

public class Message {
    protected final Cipher cipher;
    protected final byte[] bytes;

    public Message(Cipher cipher, byte[] bytes) {
        this.cipher = cipher;
        this.bytes = bytes;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public static class PlainText
    extends Message {
        public PlainText(byte[] bytes, Cipher cipher) {
            super(cipher, bytes);
        }

        public Encrypted encipher(Cipher.Key key) {
            return new Encrypted(this.cipher.encrypt(this.bytes, key), this.cipher);
        }

        public String toString() {
            return new String(this.bytes, StandardCharsets.UTF_8);
        }
    }

    public static class Encrypted
    extends Message {
        public Encrypted(byte[] bytes, Cipher cipher) {
            super(cipher, bytes);
        }

        public PlainText decrypt(Cipher.Key key) {
            return this.decrypt(key, this.bytes);
        }

        private PlainText decrypt(Cipher.Key key, byte[] bytes) {
            return new PlainText(bytes == null ? null : this.cipher.decrypt(bytes, key), this.cipher);
        }

        public static class Timestamped
        extends Encrypted {
            private final Extractor unmarshaller;

            public Timestamped(byte[] bytes, Cipher cipher, Extractor unmarshaller) {
                super(bytes, cipher);
                this.unmarshaller = unmarshaller;
            }

            @Override
            public PlainText decrypt(Cipher.Key key) {
                try {
                    return ((Encrypted)this).decrypt(key, this.unmarshaller.encrypted(this.bytes));
                }
                catch (ExtractionFailed e) {
                    return ((Encrypted)this).decrypt(key, this.bytes);
                }
            }

            public static class ExtractionFailed
            extends IllegalArgumentException {
                public ExtractionFailed() {
                }

                public ExtractionFailed(Throwable cause) {
                    super(cause);
                }
            }

            public static interface Extractor {
                public byte[] encrypted(byte[] var1);
            }

            public static interface Compactor {
                public byte[] compact(byte[] var1);
            }

            public static interface Context
            extends Compactor,
            Extractor {
            }
        }
    }

    public static class Factory {
        private final Cipher cipher;
        private final Encrypted.Timestamped.Extractor unmarshaller;

        public Factory(Cipher cipher, Encrypted.Timestamped.Extractor unmarshaller) {
            this.cipher = cipher;
            this.unmarshaller = unmarshaller;
        }

        public PlainText plain(byte[] it) {
            return new PlainText(it, this.cipher);
        }

        public Encrypted encrypted(byte[] bytes) {
            return new Encrypted(bytes, this.cipher);
        }

        public Encrypted.Timestamped timestamped(byte[] bytes) {
            return new Encrypted.Timestamped(bytes, this.cipher, this.unmarshaller);
        }
    }

    public static interface Cipher
    extends be.recipe.api.crypto.Cipher<Key> {

        public static interface Key {
            public ID id();

            public SecretKey secret();

            public static class ByID
            implements Predicate<Key> {
                private final ID id;

                static ByID byID(ID id) {
                    return new ByID(id);
                }

                public ByID(ID id) {
                    this.id = id;
                }

                public boolean test(Key key) {
                    return key.id().equals(this.id);
                }
            }

            public static class NotFound
            extends IllegalArgumentException {
            }

            public static interface Owner<V> {
                public void process(V var1);

                public static class Simple<V>
                extends ExtendableString
                implements Owner<V> {
                    static <V> Owner<V> owner(String it) {
                        return new Simple<V>(it);
                    }

                    static <V> Owner<V> owner(ExtendableString it) {
                        return Simple.owner(it.toString());
                    }

                    static <V> Owner<V> owner(byte[] it) {
                        return Simple.owner(new String(it, StandardCharsets.UTF_8));
                    }

                    private Simple(String value) {
                        super(value);
                    }

                    @Override
                    public void process(V processor) {
                    }
                }
            }

            public static interface DB<V> {
                public Key create(String var1);

                public Key get(ID var1);
            }

            public static class Simple
            implements Key {
                private final ID id;
                private final SecretKey spec;

                public static Key key(ID id, SecretKey spec) {
                    return new Simple(id, spec);
                }

                public Simple(ID id, SecretKey spec) {
                    this.id = id;
                    this.spec = spec;
                }

                @Override
                public ID id() {
                    return this.id;
                }

                @Override
                public SecretKey secret() {
                    return this.spec;
                }
            }

            public static class ID
            extends ExtendableString {
                private ID(String value) {
                    super(value);
                }

                public static ID keyID(String value) {
                    return ID.construct(value, new Function<String, ID>(){

                        public ID apply(String it) {
                            return new ID(it);
                        }
                    });
                }
            }
        }
    }
}

