/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.crypto;

import be.recipe.api.Prescription;
import be.recipe.api.crypto.Message;
import be.recipe.api.executor.Executor;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java8.util.function.Function;
import java8.util.function.Predicate;
import java8.util.function.Predicates;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;
import javax.crypto.SecretKey;

public class InmemKeyDB
implements Message.Cipher.Key.DB<Prescription.OnContent> {
    private final AtomicInteger sequence = new AtomicInteger();
    private final List<Key> keys = new ArrayList<Key>();
    private final Function<byte[], SecretKey> secret;
    public Message.Cipher.Key.Owner<Prescription.OnContent> owner;

    public InmemKeyDB(Function<byte[], SecretKey> secret) {
        this.secret = secret;
    }

    @Override
    public final Key create(String patientId) {
        Stream stream = StreamSupport.stream(Collections.singleton(this.owner));
        ArrayList<Message.Cipher.Key.Owner<Prescription.OnContent>> owners = new ArrayList<Message.Cipher.Key.Owner<Prescription.OnContent>>();
        owners.add(Executor.All.all());
        owners.add(Patient.ID.patientID(patientId));
        owners.add(PrescriberType.DOCTOR);
        owners.add(PrescriberType.HOSPITAL);
        owners.add(PrescriberType.DENTIST);
        owners.add(PrescriberType.MIDWIFE);
        Stream stream1 = StreamSupport.stream(owners);
        List totalOwners = (List)StreamSupport.stream(Arrays.asList(stream, stream1)).flatMap((Function)new Function<Stream<Message.Cipher.Key.Owner<Prescription.OnContent>>, Stream<Message.Cipher.Key.Owner<Prescription.OnContent>>>(){

            public Stream<Message.Cipher.Key.Owner<Prescription.OnContent>> apply(Stream<Message.Cipher.Key.Owner<Prescription.OnContent>> ownerStream) {
                return ownerStream;
            }
        }).collect(Collectors.toList());
        Key key = Key.key(Message.Cipher.Key.ID.keyID("key-" + this.sequence.incrementAndGet()), (SecretKey)this.secret.apply((Object)((String)StreamSupport.stream((Collection)totalOwners).flatMap(InmemKeyDB.normalize()).collect(Collectors.joining())).getBytes(StandardCharsets.UTF_8)), totalOwners.toArray(new Message.Cipher.Key.Owner[0]));
        this.keys.add(key);
        return key;
    }

    private static Stream<String> normalize(Message.Cipher.Key.Owner<Prescription.OnContent> it) {
        return InmemKeyDB.normalize(it, new DefaultKeyProcessor());
    }

    private static Function<Message.Cipher.Key.Owner<Prescription.OnContent>, Stream<String>> normalize() {
        return new Function<Message.Cipher.Key.Owner<Prescription.OnContent>, Stream<String>>(){

            public Stream<String> apply(Message.Cipher.Key.Owner<Prescription.OnContent> owner) {
                return InmemKeyDB.normalize(owner);
            }
        };
    }

    private static Stream<String> normalize(Message.Cipher.Key.Owner<Prescription.OnContent> it, DefaultKeyProcessor processor) {
        it.process(processor);
        return processor.owners();
    }

    @Override
    public Key get(Message.Cipher.Key.ID id) {
        return this.get(id, this.owner);
    }

    public Key get(Message.Cipher.Key.ID id, Message.Cipher.Key.Owner<Prescription.OnContent> owner) {
        return (Key)StreamSupport.stream(this.keys).filter(Predicates.and((Predicate)Key.byOwner(owner), (Predicate)Message.Cipher.Key.ByID.byID(id))).findFirst().orElseThrow((Supplier)new Supplier<Message.Cipher.Key.NotFound>(){

            public Message.Cipher.Key.NotFound get() {
                return new Message.Cipher.Key.NotFound();
            }
        });
    }

    private static class ProvidedOwnerProcessor
    extends DefaultKeyProcessor {
        private ProvidedOwnerProcessor() {
        }

        @Override
        public void process(Executor.ID executor) {
            this.process(Executor.All.all());
        }

        @Override
        public void process(Prescriber prescriber) {
            super.process(prescriber);
            this.process(prescriber.type());
        }
    }

    private static class DefaultKeyProcessor
    implements Prescription.OnContent {
        private final List<String> owners = new ArrayList<String>();

        private DefaultKeyProcessor() {
        }

        @Override
        public void process(Patient.ID patient) {
            this.owners.add("patient:" + patient.toString());
        }

        @Override
        public void process(Executor.ID executor) {
            this.owners.add("executor:" + executor.toString());
        }

        @Override
        public void process(Executor.All all) {
            this.owners.add("executor:all");
        }

        @Override
        public void process(PrescriberType type) {
            this.owners.add(type.name());
        }

        @Override
        public void process(Prescriber prescriber) {
            this.owners.add("prescriber:" + prescriber.id().toString());
        }

        public Stream<String> owners() {
            return StreamSupport.stream(this.owners);
        }
    }

    static class Key
    extends Message.Cipher.Key.Simple {
        private final List<Message.Cipher.Key.Owner<Prescription.OnContent>> owners;

        @SafeVarargs
        public Key(Message.Cipher.Key.ID id, SecretKey spec, Message.Cipher.Key.Owner<Prescription.OnContent> ... owners) {
            super(id, spec);
            this.owners = Arrays.asList(owners);
        }

        @SafeVarargs
        static Key key(Message.Cipher.Key.ID id, SecretKey spec, Message.Cipher.Key.Owner<Prescription.OnContent> ... owners) {
            return new Key(id, spec, owners);
        }

        static ByOwner byOwner(Message.Cipher.Key.Owner<Prescription.OnContent> owner) {
            return new ByOwner(owner);
        }

        private boolean contains(Message.Cipher.Key.Owner<Prescription.OnContent> owner) {
            final List actuals = (List)StreamSupport.stream(this.owners).flatMap(InmemKeyDB.normalize()).collect(Collectors.toList());
            List expected = (List)InmemKeyDB.normalize(owner, new ProvidedOwnerProcessor()).collect(Collectors.toList());
            return StreamSupport.stream((Collection)expected).anyMatch((Predicate)new Predicate<String>(){

                public boolean test(String it) {
                    return actuals.contains(it);
                }
            });
        }

        private static class ByOwner
        implements Predicate<Key> {
            private final Message.Cipher.Key.Owner<Prescription.OnContent> owner;

            public ByOwner(Message.Cipher.Key.Owner<Prescription.OnContent> owner) {
                this.owner = owner;
            }

            public boolean test(Key key) {
                return key.contains(this.owner);
            }
        }
    }
}

