/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.crypto;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public interface Cipher<Key> {
    public byte[] encrypt(byte[] var1, Key var2);

    public byte[] decrypt(byte[] var1, Key var2);

    public static class AES
    implements Cipher<SecretKey> {
        private final MessageDigest hasher;

        public AES() {
            try {
                this.hasher = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] encrypt(byte[] decryptedMessage, SecretKey key) {
            try {
                return this.process(1, decryptedMessage, key);
            }
            catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw new NotCipherable(e);
            }
        }

        @Override
        public byte[] decrypt(byte[] encryptedMessage, SecretKey key) {
            try {
                return this.process(2, encryptedMessage, key);
            }
            catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw new Undecipherable(e);
            }
        }

        public byte[] process(int mode, byte[] msg, SecretKey key) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
            javax.crypto.Cipher cipher = AES.cipher();
            cipher.init(mode, key);
            return cipher.doFinal(msg);
        }

        private static javax.crypto.Cipher cipher() {
            try {
                return javax.crypto.Cipher.getInstance("AES/ECB/PKCS5Padding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }

        public SecretKeySpec spec(byte[] it) {
            return new SecretKeySpec(Arrays.copyOf(this.hasher.digest(it), 32), "AES");
        }
    }

    public static class NotCipherable
    extends IllegalArgumentException {
        public NotCipherable(Throwable cause) {
            super(cause);
        }
    }

    public static class Undecipherable
    extends IllegalArgumentException {
        public Undecipherable(Throwable cause) {
            super(cause);
        }
    }
}

