/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.constraints;

import be.recipe.api.constraints.Rejected;
import be.recipe.api.constraints.Violation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java8.util.function.Supplier;
import java8.util.stream.Collectors;
import java8.util.stream.Stream;
import java8.util.stream.StreamSupport;

public interface ValidationReport {
    public Stream<Violation> stream();

    public ValidationReport ifRejectedThrow();

    public void orElse(Runnable var1);

    public <T> T orElse(Supplier<T> var1);

    public static class Simple
    implements ValidationReport {
        private List<Violation> violations = Collections.emptyList();

        public static ValidationReport empty() {
            return new Simple();
        }

        public static ValidationReport from(List<Violation> violations) {
            return new Simple(violations);
        }

        public static ValidationReport from(Violation.Simple.Builder ... violations) {
            return Simple.from((List)StreamSupport.stream(Arrays.asList(violations)).map(Violation.Simple.Builder.toViolation()).collect(Collectors.toList()));
        }

        public Simple() {
        }

        public Simple(List<Violation> violations) {
            this.violations = violations;
        }

        @Override
        public void orElse(Runnable task) {
            task.run();
        }

        @Override
        public <T> T orElse(Supplier<T> task) {
            return (T)task.get();
        }

        @Override
        public ValidationReport ifRejectedThrow() {
            if (!this.violations.isEmpty()) {
                throw new Rejected(this);
            }
            return this;
        }

        @Override
        public Stream<Violation> stream() {
            return StreamSupport.stream(this.violations);
        }

        public void violations(Violation.Simple.Builder ... violations) {
            this.violations = (List)StreamSupport.stream(Arrays.asList(violations)).map(Violation.Simple.Builder.toViolation()).collect(Collectors.toList());
        }

        public String toString() {
            return "ValidationReport{violations=" + this.violations + '}';
        }
    }
}

