/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api.constraints;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;

@Inherited
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD})
@Constraint(validatedBy={Validator.class})
public @interface Known {
    public String message() default "unknown";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class RoutingValidator
    implements Validator {
        private final Map<Class<?>, Validator> map;

        public RoutingValidator(Map<Class<?>, Validator> map) {
            this.map = map;
        }

        public boolean isValid(Object it, ConstraintValidatorContext context) {
            if (this.map.containsKey(it.getClass())) {
                return this.map.get(it.getClass()).isValid(it, context);
            }
            throw new IllegalArgumentException("No validator found for " + it.getClass() + "!");
        }
    }

    public static interface Validator
    extends ConstraintValidator<Known, Object> {
    }
}

