/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.ArchivingPrescriptionService;
import be.recipe.api.CipheringPrescriptionService;
import be.recipe.api.MandateService;
import be.recipe.api.PrefetchingPrescriptionService;
import be.recipe.api.Prescription;
import be.recipe.api.PrescriptionContent;
import be.recipe.api.PrescriptionService;
import be.recipe.api.crypto.Message;
import be.recipe.api.reservation.ReservationService;

public class Recipe {
    private final Infrastructure infrastructure;

    public Recipe(Infrastructure infrastructure) {
        this.infrastructure = infrastructure;
    }

    public PrescriptionService.Ciphering.Simplified cipheringPrescriptionService() {
        return new PrefetchingPrescriptionService(new CipheringPrescriptionService(new ArchivingPrescriptionService(this.infrastructure.prescriptionService(), this.infrastructure.timestampingContext(), this.prescriptionContentFactory()), this.prescriptionContentFactory()));
    }

    public ReservationService.Simplified reservationService() {
        return this.infrastructure.reservationService();
    }

    public MandateService.Simplified mandateService() {
        return this.infrastructure.mandateService();
    }

    public PrescriptionContent.Factory prescriptionContentFactory() {
        PrescriptionContent.Factory factory = new PrescriptionContent.Factory(new Message.Factory(this.infrastructure.cipher(), this.infrastructure.timestampingContext()), this.infrastructure.keyRegistry());
        return factory;
    }

    public static interface Infrastructure {
        public PrescriptionService.Simplified prescriptionService();

        public Message.Cipher cipher();

        public Message.Cipher.Key.DB<Prescription.OnContent> keyRegistry();

        public Message.Encrypted.Timestamped.Extractor timestampingContext();

        public ReservationService.Simplified reservationService();

        public MandateService.Simplified mandateService();
    }
}

