/*
 * Decompiled with CFR 0.152.
 */
package be.recipe.api;

import be.recipe.api.Actor;
import be.recipe.api.GetPrescriptionStatusResponse;
import be.recipe.api.Registered;
import be.recipe.api.executor.Executor;
import be.recipe.api.executor.ExecutorViewer;
import be.recipe.api.patient.Patient;
import be.recipe.api.prescriber.Prescriber;
import be.recipe.api.prescriber.PrescriberType;
import be.recipe.api.prescriber.VisionOtherPrescribers;
import be.recipe.api.reservation.Reservation;
import be.recipe.api.text.ExtendableString;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.Optional;
import java8.util.function.Function;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public interface Prescription
extends Registered,
GetPrescriptionStatusResponse {
    public static final String not_found = "error.prescription.rid.unknown";
    public static final String status_should_be_x = "status.should.be.%s";
    public static final String status_should_not_be_x = "status.should.not.be.%s";
    public static final String status_should_not_be_x_legacy = "error.request.prescription.status";
    public static final String not_status_with_updater = "error.request.prescription.status2";
    public static final String illegal_access = "error.getPrescription.illegalaccess";
    public static final String delivery_in_progress = "prescription.not.available.for.delivery";
    public static final String vision_incompatible_with_reservation = "error.vision.reservation.notcompatible1";
    public static final String reserved = "reserved";
    public static final String expired = "error.prescription.expired";
    public static final String in_process = "error.updatePrescriptionStatus.locked";
    public static final String expirationdate_required = "error.validation.expirationdate1";
    public static final String expirationdate_too_far_in_future = "error.validation.expirationdate2";
    public static final String expirationdate_already_passed = "error.validation.expirationdate3";
    public static final String expirationdate_invalid_format = "error.validation.expirationdate4";
    public static final String mandate_required = "error.missing.patient.relation";
    public static final String permission_required_to_prescribe = "error.permission.required.to.prescribe.medication";
    public static final String prescription_not_available = "error.prescription.not.available";

    public Prescriber prescriber();

    public Patient patient();

    public Type type();

    public LocalDateTime creationDate();

    public LocalDate expirationDate();

    public boolean feedbackAllowed();

    public ExecutorViewer visibleToExecutors();

    public VisionOtherPrescribers visionOtherPrescribers();

    @Override
    public Status status();

    public Actor.ID statusUpdater();

    @Override
    public Executor executor();

    public Optional<Reservation> reservation();

    public static class Wrapper<T extends Prescription>
    implements Prescription {
        protected final T target;

        public Wrapper(T target) {
            this.target = target;
        }

        @Override
        public RID rid() {
            return this.target.rid();
        }

        @Override
        public Prescriber prescriber() {
            return this.target.prescriber();
        }

        @Override
        public Patient patient() {
            return this.target.patient();
        }

        @Override
        public Type type() {
            return this.target.type();
        }

        @Override
        public LocalDateTime creationDate() {
            return this.target.creationDate();
        }

        @Override
        public LocalDate expirationDate() {
            return this.target.expirationDate();
        }

        @Override
        public boolean feedbackAllowed() {
            return this.target.feedbackAllowed();
        }

        @Override
        public ExecutorViewer visibleToExecutors() {
            return this.target.visibleToExecutors();
        }

        @Override
        public VisionOtherPrescribers visionOtherPrescribers() {
            return this.target.visionOtherPrescribers();
        }

        @Override
        public Status status() {
            return this.target.status();
        }

        @Override
        public Actor.ID statusUpdater() {
            return this.target.statusUpdater();
        }

        @Override
        public Executor executor() {
            return this.target.executor();
        }

        @Override
        public Optional<Reservation> reservation() {
            return this.target.reservation();
        }
    }

    public static class Abstract
    implements Prescription {
        private LocalDateTime creationDate;
        private LocalDate expirationDate;
        private VisionOtherPrescribers visionOtherPrescribers;
        private ExecutorViewer visibleToExecutors;
        private boolean feedbackAllowed;
        private Reservation reservation;
        private Actor.ID statusUpdater;
        private Prescriber prescriber;
        private Executor executor;
        private Patient patient;
        private Status status;
        private Type type;
        private RID rid;

        public void setRid(RID rid) {
            this.rid = rid;
        }

        public Abstract rid(RID rid) {
            this.setRid(rid);
            return this;
        }

        public void setPrescriber(Prescriber prescriber) {
            this.prescriber = prescriber;
        }

        public void setPatient(Patient patient) {
            this.patient = patient;
        }

        public void setCreationDate(LocalDateTime creationDate) {
            this.creationDate = creationDate;
        }

        public void setExpirationDate(LocalDate expirationDate) {
            this.expirationDate = expirationDate;
        }

        public void setFeedbackAllowed(boolean feedbackAllowed) {
            this.feedbackAllowed = feedbackAllowed;
        }

        public void setVisibleToExecutors(ExecutorViewer visibleToExecutors) {
            this.visibleToExecutors = visibleToExecutors;
        }

        public void setVisionOtherPrescribers(VisionOtherPrescribers visionOtherPrescribers) {
            this.visionOtherPrescribers = visionOtherPrescribers;
        }

        public void setReservation(Reservation reservation) {
            this.reservation = reservation;
        }

        public void setStatusUpdater(Actor.ID statusUpdater) {
            this.statusUpdater = statusUpdater;
        }

        public void setType(Type type) {
            this.type = type;
        }

        @Override
        public RID rid() {
            return this.rid;
        }

        @Override
        public Prescriber prescriber() {
            return this.prescriber;
        }

        @Override
        public Patient patient() {
            return this.patient;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public LocalDateTime creationDate() {
            return this.creationDate;
        }

        @Override
        public LocalDate expirationDate() {
            return this.expirationDate;
        }

        @Override
        public boolean feedbackAllowed() {
            return this.feedbackAllowed;
        }

        @Override
        public ExecutorViewer visibleToExecutors() {
            return this.visibleToExecutors;
        }

        @Override
        public VisionOtherPrescribers visionOtherPrescribers() {
            return this.visionOtherPrescribers;
        }

        @Override
        public Status status() {
            return this.status;
        }

        @Override
        public Actor.ID statusUpdater() {
            return this.statusUpdater;
        }

        @Override
        public Executor executor() {
            return this.executor;
        }

        @Override
        public Optional<Reservation> reservation() {
            return Optional.ofNullable((Object)this.reservation);
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setExecutor(Executor executor) {
            this.executor = executor;
        }
    }

    public static interface Predicate {
    }

    public static enum Attribute {
        prescriptionDate,
        reservationModificationDate;

    }

    public static enum Status {
        NotDelivered,
        InProcess,
        Delivered,
        Revoked,
        Archived,
        Expired;

        private static final Map<Status, List<Status>> transitionMap;

        public boolean transitionsTo(Status status) {
            return this == status || ((List)Optional.ofNullable(transitionMap.get((Object)this)).orElse(Collections.emptyList())).contains((Object)status);
        }

        public boolean notFinal() {
            return transitionMap.containsKey((Object)this);
        }

        static {
            transitionMap = new HashMap<Status, List<Status>>(){
                {
                    this.put(NotDelivered, Collections.singletonList(InProcess));
                    this.put(InProcess, Arrays.asList(NotDelivered, Delivered));
                }
            };
        }

        @Inherited
        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        @Constraint(validatedBy={Validator.class})
        public static @interface ShouldNotBe {
            public String message() default "status.should.not.be.%s";

            public Status[] status();

            public Class<?>[] groups() default {};

            public Class<? extends Payload>[] payload() default {};

            public static class Validator
            implements ConstraintValidator<ShouldNotBe, Status> {
                private List<Status> exclusions;

                public void initialize(ShouldNotBe constraintAnnotation) {
                    this.exclusions = Arrays.asList(constraintAnnotation.status());
                }

                public boolean isValid(Status status, ConstraintValidatorContext context) {
                    return !this.exclusions.contains((Object)status);
                }
            }
        }

        @Inherited
        @Documented
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.FIELD})
        @Constraint(validatedBy={Validator.class})
        public static @interface ShouldBe {
            public String message() default "status.should.be.%s";

            public Status status();

            public Class<?>[] groups() default {};

            public Class<? extends Payload>[] payload() default {};

            public static class Validator
            implements ConstraintValidator<ShouldBe, Status> {
                private Status expected;

                public void initialize(ShouldBe constraintAnnotation) {
                    this.expected = constraintAnnotation.status();
                }

                public boolean isValid(Status status, ConstraintValidatorContext context) {
                    return status == this.expected;
                }
            }
        }
    }

    public static abstract class Specification {
        @NotNull
        public Patient patient;
        @NotNull(message="error.validation.expirationdate1")
        public @NotNull(message="error.validation.expirationdate1") LocalDate expirationDate;
        public boolean feedbackAllowed;
        @NotNull
        public Type type;
        public Product.Code productCode;
        public ExecutorViewer visibleToExecutor;
        public VisionOtherPrescribers visionOtherPrescribers;

        public Specification() {
        }

        public Specification(Specification spec) {
            this.type = spec.type;
            this.patient = spec.patient;
            this.productCode = spec.productCode;
            this.expirationDate = spec.expirationDate;
            this.feedbackAllowed = spec.feedbackAllowed;
            this.visibleToExecutor = spec.visibleToExecutor;
            this.visionOtherPrescribers = spec.visionOtherPrescribers;
        }
    }

    public static interface OnContent {
        public void process(Patient.ID var1);

        public void process(Executor.ID var1);

        public void process(Executor.All var1);

        public void process(PrescriberType var1);

        public void process(Prescriber var1);
    }

    public static interface Encrypted
    extends Prescription {
        public byte[] encryptedContent();

        public String encryptionKey();

        public static class Wrapper
        extends be.recipe.api.Prescription$Wrapper<Encrypted>
        implements Encrypted {
            public Wrapper(Encrypted target) {
                super(target);
            }

            @Override
            public byte[] encryptedContent() {
                return ((Encrypted)this.target).encryptedContent();
            }

            @Override
            public String encryptionKey() {
                return ((Encrypted)this.target).encryptionKey();
            }
        }

        public static class Simple
        extends Abstract
        implements Encrypted {
            private byte[] encryptedContent;
            private String encryptionKey;

            public static Simple encrypted() {
                return new Simple();
            }

            @Override
            public Simple rid(RID rid) {
                return (Simple)super.rid(rid);
            }

            @Override
            public byte[] encryptedContent() {
                return this.encryptedContent;
            }

            @Override
            public String encryptionKey() {
                return this.encryptionKey;
            }

            public void setEncryptedContent(byte[] encryptedContent) {
                this.encryptedContent = encryptedContent;
            }

            public void setEncryptionKey(String encryptionKey) {
                this.encryptionKey = encryptionKey;
            }
        }

        public static class Specification
        extends be.recipe.api.Prescription$Specification {
            @NotNull
            public byte[] encryptedContent;
            @NotNull
            public String encryptionKeyId;

            public Specification() {
            }

            public Specification(be.recipe.api.Prescription$Specification spec) {
                super(spec);
            }

            public Specification(Specification spec) {
                super(spec);
                this.encryptedContent = spec.encryptedContent;
                this.encryptionKeyId = spec.encryptionKeyId;
            }
        }
    }

    public static interface PlainText
    extends Prescription {
        public String content();

        public static class Wrapper
        extends be.recipe.api.Prescription$Wrapper<PlainText>
        implements PlainText {
            public Wrapper(PlainText target) {
                super(target);
            }

            @Override
            public String content() {
                return ((PlainText)this.target).content();
            }
        }

        public static class Simple
        extends Abstract
        implements PlainText {
            private String content;

            @Override
            public String content() {
                return this.content;
            }

            public void setContent(String content) {
                this.content = content;
            }
        }

        public static class Specification
        extends be.recipe.api.Prescription$Specification {
            public String content;
        }
    }

    public static interface Product {

        public static class Code
        extends ExtendableString {
            private Code(String value) {
                super(value);
            }

            public static Code productCode(String value) {
                return Code.construct(value, new Function<String, Code>(){

                    public Code apply(String it) {
                        return new Code(it);
                    }
                });
            }
        }
    }

    public static class Type
    extends ExtendableString {
        private Type(String value) {
            super(value);
        }

        public static Type prescriptionType(String it) {
            return Type.construct(it, new Function<String, Type>(){

                public Type apply(String it) {
                    return new Type(it);
                }
            });
        }
    }

    public static class RID
    extends ExtendableString {
        private RID(String value) {
            super(value);
        }

        public static RID prescriptionID(String id) {
            return RID.construct(id, new Function<String, RID>(){

                public RID apply(String it) {
                    return new RID(it);
                }
            });
        }
    }
}

